/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cmis.model;

import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;

public enum TypeId {
    SILVERPEAS_SPACE(BaseTypeId.CMIS_FOLDER, "slvp:space"),
    SILVERPEAS_APPLICATION(BaseTypeId.CMIS_FOLDER, "slvp:application"),
    SILVERPEAS_FOLDER(BaseTypeId.CMIS_FOLDER, "slvp:folder"),
    SILVERPEAS_PUBLICATION(BaseTypeId.CMIS_FOLDER, "slvp:publication"),
    SILVERPEAS_DOCUMENT(BaseTypeId.CMIS_DOCUMENT, "slvp:document");

    private final String value;
    private final BaseTypeId baseTypeId;

    private TypeId(BaseTypeId baseTypeId, String value) {
        this.baseTypeId = baseTypeId;
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public BaseTypeId getBaseTypeId() {
        return this.baseTypeId;
    }

    public static TypeId fromValue(String v) {
        for (TypeId c : TypeId.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public String toString() {
        switch (this) {
            case SILVERPEAS_SPACE: {
                return "collaborative space";
            }
            case SILVERPEAS_APPLICATION: {
                return "application";
            }
            case SILVERPEAS_FOLDER: {
                return "node";
            }
            case SILVERPEAS_PUBLICATION: {
                return "publication";
            }
            case SILVERPEAS_DOCUMENT: {
                return "attached document";
            }
        }
        return this.name();
    }
}

