/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.clipboard.service;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.transaction.Transactional;
import org.silverpeas.core.clipboard.ClipboardException;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.service.Clipboard;
import org.silverpeas.core.clipboard.service.MainClipboard;
import org.silverpeas.core.index.indexing.model.IndexEntry;

@SessionScoped
@Transactional
@MainClipboard
public class MainClipboardService
implements Clipboard,
Serializable {
    private static final long serialVersionUID = -824732581358882058L;
    private ClipboardSelection lastObject = null;
    private List<ClipboardSelection> objectsInClipboard = null;
    private boolean multipleClipboardSupported = true;
    private boolean addingToSelection = true;
    private int count = 0;
    private String errorMessage = null;
    private Exception error = null;

    @Override
    public void add(ClipboardSelection objectToCopy) throws ClipboardException {
        try {
            ++this.count;
            if (objectToCopy != null) {
                if (!this.addingToSelection) {
                    this.unselectAllItems();
                }
                int index = this.indexOfObjectThatShouldBeSelected(objectToCopy);
                this.lastObject = objectToCopy;
                if (index >= 0) {
                    this.objectsInClipboard.set(index, this.lastObject);
                    this.lastObject.setSelected(true);
                } else if (this.multipleClipboardSupported) {
                    this.objectsInClipboard.add(this.lastObject);
                    this.lastObject.setSelected(true);
                }
            }
        }
        catch (Exception e) {
            throw new ClipboardException("Error while adding object into the clipboard", e);
        }
    }

    private int indexOfObjectThatShouldBeSelected(ClipboardSelection objectToCopy) throws UnsupportedFlavorException {
        int index = -1;
        if (objectToCopy.isDataFlavorSupported(ClipboardSelection.IndexFlavor)) {
            IndexEntry mainIndexEntry = (IndexEntry)objectToCopy.getTransferData(ClipboardSelection.IndexFlavor);
            for (int i = 0; i < this.objectsInClipboard.size(); ++i) {
                IndexEntry indexEntry;
                ClipboardSelection clipObject = this.objectsInClipboard.get(i);
                if (!clipObject.isDataFlavorSupported(ClipboardSelection.IndexFlavor) || !(indexEntry = (IndexEntry)clipObject.getTransferData(ClipboardSelection.IndexFlavor)).equals(mainIndexEntry)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    private void unselectAllItems() {
        this.objectsInClipboard.forEach(c -> c.setSelected(false));
        this.addingToSelection = true;
    }

    @Override
    public ClipboardSelection getObject() {
        ++this.count;
        return this.lastObject;
    }

    @Override
    public Collection<ClipboardSelection> getObjects() {
        ++this.count;
        return Collections.unmodifiableCollection(this.objectsInClipboard);
    }

    @Override
    public Collection<ClipboardSelection> getSelectedObjects() throws ClipboardException {
        try {
            ++this.count;
            return this.objectsInClipboard.stream().filter(ClipboardSelection::isSelected).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new ClipboardException("Error while getting the selected object from the clipboard", e);
        }
    }

    @Override
    public int size() throws ClipboardException {
        try {
            return this.objectsInClipboard.size();
        }
        catch (Exception e) {
            throw new ClipboardException("Error while computing the clipboard size", e);
        }
    }

    @Override
    public ClipboardSelection getObject(int index) throws ClipboardException {
        try {
            return this.objectsInClipboard.get(index);
        }
        catch (Exception e) {
            throw new ClipboardException("Error while getting the object at index " + index + " from the clipboard", e);
        }
    }

    @Override
    public void pasteDone() {
        this.addingToSelection = false;
        this.objectsInClipboard.stream().filter(ClipboardSelection::isCut).forEach(c -> c.setSelected(false));
    }

    @Override
    public void setSelected(int index, boolean setIt) throws ClipboardException {
        try {
            ClipboardSelection clipObject = this.objectsInClipboard.get(index);
            if (clipObject != null) {
                clipObject.setSelected(setIt);
            }
        }
        catch (Exception e) {
            throw new ClipboardException("Error while selecting or deselecting the object at index " + index + " in the clipboard", e);
        }
    }

    @Override
    public void removeObject(int index) throws ClipboardException {
        try {
            this.objectsInClipboard.remove(index);
        }
        catch (Exception e) {
            throw new ClipboardException("Error while removing the object at index " + index + " from the clipboard", e);
        }
    }

    @Override
    public void clear() {
        this.objectsInClipboard.clear();
        this.lastObject = null;
    }

    @Override
    public void setMultiClipboard() throws ClipboardException {
        try {
            this.multipleClipboardSupported = true;
            if (this.lastObject != null) {
                this.objectsInClipboard.clear();
                this.objectsInClipboard.add(this.lastObject);
            }
        }
        catch (Exception e) {
            throw new ClipboardException("Error while enabling the support of multi-clipboards", e);
        }
    }

    @Override
    public void setSingleClipboard() {
        this.multipleClipboardSupported = false;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public String getMessageError() {
        String message = this.errorMessage;
        this.errorMessage = null;
        return message;
    }

    @Override
    public Exception getExceptionError() {
        Exception valret = this.error;
        this.error = null;
        return valret;
    }

    @Override
    public void setMessageError(String messageID, Exception e) {
        this.errorMessage = messageID;
        this.error = e;
    }

    @PostConstruct
    public void setUp() {
        this.lastObject = null;
        this.objectsInClipboard = new ArrayList<ClipboardSelection>();
    }
}

