/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.ArrayList;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.kernel.annotation.NonNull;

public abstract class ClipboardSelection
implements Serializable,
ClipboardOwner,
Transferable {
    private static final long serialVersionUID = 7296607705319157979L;
    public static final DataFlavor IndexFlavor = new DataFlavor("silverpeas/index", "Silverpeas index");
    public static final DataFlavor SilverpeasKeyDataFlavor = new DataFlavor("silverpeas/keydata", "Silverpeas keydata");
    protected ArrayList<DataFlavor> supportedFlavorsList = new ArrayList();
    protected boolean selected = true;
    private boolean isCut = false;

    protected ClipboardSelection() {
        this.supportedFlavorsList.add(IndexFlavor);
        this.supportedFlavorsList.add(SilverpeasKeyDataFlavor);
    }

    protected void addFlavor(DataFlavor parFlavor) {
        this.supportedFlavorsList.add(parFlavor);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor parFlavor) {
        if (parFlavor == null) {
            return false;
        }
        return this.supportedFlavorsList.contains(parFlavor);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.supportedFlavorsList.toArray(new DataFlavor[0]);
    }

    @Override
    @NonNull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        if (IndexFlavor.equals(parFlavor)) {
            return this.getIndexEntry();
        }
        if (SilverpeasKeyDataFlavor.equals(parFlavor)) {
            return this.getKeyData();
        }
        throw new UnsupportedFlavorException(parFlavor);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean setIt) {
        this.selected = setIt;
    }

    @Override
    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    protected abstract IndexEntry getIndexEntry();

    protected abstract SilverpeasKeyData getKeyData();

    public boolean isCut() {
        return this.isCut;
    }

    public void setCut(boolean isCut) {
        this.isCut = isCut;
    }
}

