/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.ical4j;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.RRule;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.DayOfWeekOccurrence;
import org.silverpeas.core.calendar.Recurrence;
import org.silverpeas.core.calendar.RecurrencePeriod;
import org.silverpeas.core.calendar.ical4j.ICal4JDateCodec;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Singleton
public class ICal4JRecurrenceCodec {
    private final ICal4JDateCodec iCal4JDateCodec;

    @Inject
    public ICal4JRecurrenceCodec(ICal4JDateCodec iCal4JDateCodec) {
        this.iCal4JDateCodec = iCal4JDateCodec;
    }

    public DateList convertExceptionDates(CalendarEvent event) {
        Recurrence recurrence = event.getRecurrence();
        if (recurrence == Recurrence.NO_RECURRENCE) {
            throw new IllegalArgumentException("The event isn't recurrent!");
        }
        return recurrence.getExceptionDates().stream().map(date -> (Date)TemporalConverter.applyByType((Temporal)date, (TemporalConverter.Conversion[])new TemporalConverter.Conversion[]{this.iCal4JDateCodec.localDateConversion(), this.iCal4JDateCodec.offsetDateTimeConversion()})).sorted().collect(Collectors.toCollection(() -> {
            Value type = event.isOnAllDay() ? Value.DATE : Value.DATE_TIME;
            DateList list = new DateList(type);
            if (this.iCal4JDateCodec.isEventDateToBeEncodedIntoUtc(event.isRecurrent(), event.asCalendarComponent())) {
                list.setUtc(true);
            } else {
                list.setUtc(false);
                list.setTimeZone(this.iCal4JDateCodec.getTimeZone(event.getCalendar().getZoneId()));
            }
            return list;
        }));
    }

    public Recur encode(CalendarEvent event) {
        Recurrence eventRecurrence = event.getRecurrence();
        if (eventRecurrence == Recurrence.NO_RECURRENCE) {
            throw new IllegalArgumentException("Event recurrence missing!");
        }
        Recur.Builder recurBuilder = new Recur.Builder().frequency(this.asICal4JFrequency(eventRecurrence.getFrequency()));
        if (eventRecurrence.getFrequency().getInterval() > 1) {
            recurBuilder.interval(Integer.valueOf(eventRecurrence.getFrequency().getInterval()));
        }
        Optional recurrenceEndDate = eventRecurrence.getRecurrenceEndDate();
        if (eventRecurrence.getRecurrenceCount() != 0) {
            recurBuilder.count(Integer.valueOf(eventRecurrence.getRecurrenceCount()));
        } else if (recurrenceEndDate.isPresent()) {
            Temporal endDate = (Temporal)recurrenceEndDate.get();
            TemporalConverter.consumeByType((Temporal)endDate, date -> recurBuilder.until(this.iCal4JDateCodec.encode((LocalDate)date)), dateTime -> recurBuilder.until((Date)this.iCal4JDateCodec.encode((OffsetDateTime)dateTime)));
        }
        WeekDayList daysOfWeek = eventRecurrence.getDaysOfWeek().stream().sorted(Comparator.comparing(DayOfWeekOccurrence::dayOfWeek)).map(this::encode).collect(Collectors.toCollection(WeekDayList::new));
        recurBuilder.dayList(daysOfWeek);
        return recurBuilder.build();
    }

    public WeekDay encode(DayOfWeek dayOfWeek) {
        WeekDay weekDay = null;
        switch (dayOfWeek) {
            case MONDAY: {
                weekDay = WeekDay.MO;
                break;
            }
            case TUESDAY: {
                weekDay = WeekDay.TU;
                break;
            }
            case WEDNESDAY: {
                weekDay = WeekDay.WE;
                break;
            }
            case THURSDAY: {
                weekDay = WeekDay.TH;
                break;
            }
            case FRIDAY: {
                weekDay = WeekDay.FR;
                break;
            }
            case SATURDAY: {
                weekDay = WeekDay.SA;
                break;
            }
            case SUNDAY: {
                weekDay = WeekDay.SU;
            }
        }
        return weekDay;
    }

    public Recurrence decode(VEvent vEvent) {
        Recur recur = ((RRule)vEvent.getProperty("RRULE")).getRecur();
        if (recur == null) {
            throw new IllegalArgumentException("VEVENT recurrence missing!");
        }
        RecurrencePeriod recurrencePeriod = this.decodeRecurrencePeriod(recur);
        Recurrence recurrence = Recurrence.from((RecurrencePeriod)recurrencePeriod);
        if (recur.getCount() > 0) {
            recurrence.until(recur.getCount());
        } else if (recur.getUntil() != null) {
            Temporal temporalUntil = this.iCal4JDateCodec.decode(recur.getUntil());
            recurrence.until(temporalUntil);
        }
        if (recur.getDayList() != null && !recur.getDayList().isEmpty()) {
            recurrence.on(recur.getDayList().stream().map(this::decode).collect(Collectors.toList()));
        }
        this.processExclusionDates(vEvent, recurrence);
        return recurrence;
    }

    private void processExclusionDates(VEvent vEvent, Recurrence recurrence) {
        vEvent.getProperties("EXDATE").forEach(e -> ((ExDate)e).getDates().forEach(exDate -> {
            Temporal dateToExclude = this.iCal4JDateCodec.decode((Date)exDate);
            recurrence.excludeEventOccurrencesStartingAt(new Temporal[]{dateToExclude});
        }));
    }

    private Recur.Frequency asICal4JFrequency(RecurrencePeriod period) {
        Recur.Frequency freq;
        switch (period.getUnit()) {
            case SECOND: {
                freq = Recur.Frequency.SECONDLY;
                break;
            }
            case MINUTE: {
                freq = Recur.Frequency.MINUTELY;
                break;
            }
            case HOUR: {
                freq = Recur.Frequency.HOURLY;
                break;
            }
            case DAY: {
                freq = Recur.Frequency.DAILY;
                break;
            }
            case WEEK: {
                freq = Recur.Frequency.WEEKLY;
                break;
            }
            case MONTH: {
                freq = Recur.Frequency.MONTHLY;
                break;
            }
            case YEAR: {
                freq = Recur.Frequency.YEARLY;
                break;
            }
            default: {
                throw new SilverpeasRuntimeException("Recurrence frequency not supported: " + String.valueOf(period.getUnit()));
            }
        }
        return freq;
    }

    private WeekDay encode(DayOfWeekOccurrence dayOfWeekOccurrence) {
        WeekDay weekday = this.encode(dayOfWeekOccurrence.dayOfWeek());
        if (dayOfWeekOccurrence.nth() != 0) {
            weekday = new WeekDay(weekday, dayOfWeekOccurrence.nth());
        }
        return weekday;
    }

    private RecurrencePeriod decodeRecurrencePeriod(Recur recur) {
        RecurrencePeriod recurrencePeriod;
        int interval = recur.getInterval() == -1 ? 1 : recur.getInterval();
        switch (recur.getFrequency()) {
            case SECONDLY: {
                recurrencePeriod = RecurrencePeriod.every((int)interval, (TimeUnit)TimeUnit.SECOND);
                break;
            }
            case MINUTELY: {
                recurrencePeriod = RecurrencePeriod.every((int)interval, (TimeUnit)TimeUnit.MINUTE);
                break;
            }
            case HOURLY: {
                recurrencePeriod = RecurrencePeriod.every((int)interval, (TimeUnit)TimeUnit.HOUR);
                break;
            }
            case DAILY: {
                recurrencePeriod = RecurrencePeriod.every((int)interval, (TimeUnit)TimeUnit.DAY);
                break;
            }
            case WEEKLY: {
                recurrencePeriod = RecurrencePeriod.every((int)interval, (TimeUnit)TimeUnit.WEEK);
                break;
            }
            case MONTHLY: {
                recurrencePeriod = RecurrencePeriod.every((int)interval, (TimeUnit)TimeUnit.MONTH);
                break;
            }
            case YEARLY: {
                recurrencePeriod = RecurrencePeriod.every((int)interval, (TimeUnit)TimeUnit.YEAR);
                break;
            }
            default: {
                throw new IllegalArgumentException("not handled recurrence period");
            }
        }
        return recurrencePeriod;
    }

    private DayOfWeekOccurrence decode(WeekDay weekDay) {
        return DayOfWeekOccurrence.nth((int)weekDay.getOffset(), (DayOfWeek)this.decode(weekDay.getDay()));
    }

    private DayOfWeek decode(WeekDay.Day weekDay) {
        DayOfWeek dayOfWeek = null;
        switch (weekDay) {
            case MO: {
                dayOfWeek = DayOfWeek.MONDAY;
                break;
            }
            case TU: {
                dayOfWeek = DayOfWeek.TUESDAY;
                break;
            }
            case WE: {
                dayOfWeek = DayOfWeek.WEDNESDAY;
                break;
            }
            case TH: {
                dayOfWeek = DayOfWeek.THURSDAY;
                break;
            }
            case FR: {
                dayOfWeek = DayOfWeek.FRIDAY;
                break;
            }
            case SA: {
                dayOfWeek = DayOfWeek.SATURDAY;
                break;
            }
            case SU: {
                dayOfWeek = DayOfWeek.SUNDAY;
            }
        }
        return dayOfWeek;
    }
}

