/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.ical4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserFactory;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.CalendarEventOccurrenceBuilder;
import org.silverpeas.core.calendar.Priority;
import org.silverpeas.core.calendar.Recurrence;
import org.silverpeas.core.calendar.VisibilityLevel;
import org.silverpeas.core.calendar.ical4j.ICal4JDateCodec;
import org.silverpeas.core.calendar.ical4j.ICal4JRecurrenceCodec;
import org.silverpeas.core.calendar.icalendar.ICalendarImporter;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.importexport.ImportDescriptor;
import org.silverpeas.core.importexport.ImportException;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.model.jpa.JpaEntityReflection;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ICal4JImporter
implements ICalendarImporter {
    private static final String CALENDAR_SETTINGS = "org.silverpeas.calendar.settings.calendar";
    @Inject
    private ICal4JDateCodec iCal4JDateCodec;
    @Inject
    private ICal4JRecurrenceCodec iCal4JRecurrenceCodec;

    @PostConstruct
    private void init() {
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
    }

    public void imports(ImportDescriptor descriptor, Consumer<Stream<Pair<CalendarEvent, List<CalendarEventOccurrence>>>> consumer) throws ImportException {
        try {
            CalendarBuilder builder = new CalendarBuilder((CalendarParser)CalendarParserFactory.getInstance().get());
            Calendar calendar = builder.build(this.getCalendarInputStream(descriptor));
            if (calendar.getComponents().isEmpty()) {
                consumer.accept(Stream.empty());
                return;
            }
            calendar.validate();
            LinkedHashMap<String, List> readEvents = new LinkedHashMap<String, List>();
            calendar.getComponents().forEach(component -> {
                if (component instanceof VEvent) {
                    VEvent vEvent = (VEvent)component;
                    String vEventId = vEvent.getUid().getValue();
                    List vEvents = readEvents.computeIfAbsent(vEventId, k -> new ArrayList());
                    Optional.ofNullable(vEvent.getRecurrenceId()).ifPresentOrElse(r -> vEvents.add(vEvent), () -> vEvents.add(0, vEvent));
                } else {
                    SilverLogger.getLogger((Object)this).debug(() -> component instanceof VTimeZone ? String.format("iCalendar VTimeZone '%s' detected", component.getName()) : String.format("iCalendar component '%s' is not handled", component.getName()));
                }
            });
            ArrayList events = new ArrayList(readEvents.size());
            readEvents.forEach((vEventId, vEvents) -> {
                VEvent vEvent = (VEvent)vEvents.remove(0);
                CalendarEvent event = this.eventFromICalEvent((String)vEventId, vEvent);
                ArrayList occurrences = new ArrayList(vEvents.size());
                vEvents.forEach(v -> {
                    CalendarEventOccurrence occurrence = this.occurrenceFromICalEvent(event, (VEvent)v);
                    occurrences.add(occurrence);
                });
                if (!event.isRecurrent() && !occurrences.isEmpty()) {
                    SilverLogger.getLogger((Object)this).warn("event with uuid {0} has no recurrence set whereas {1,choice, 1#one linked occurrence exists| 1<{1} linked occurrences exist}... Setting a default recurrence (RRULE:FREQ=DAILY;COUNT=1) to get correct data for Silverpeas", new Object[]{event.getExternalId(), occurrences.size()});
                    event.recur(Recurrence.every((int)1, (TimeUnit)TimeUnit.DAY).until(1));
                }
                events.add(Pair.of((Object)event, occurrences));
            });
            consumer.accept(events.stream());
        }
        catch (IOException | ParserException e) {
            throw new ImportException(e);
        }
    }

    private InputStream getCalendarInputStream(ImportDescriptor descriptor) throws IOException {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)CALENDAR_SETTINGS);
        String replacements = settings.getString("calendar.import.ics.file.replace.before.process", "");
        if (StringUtil.isDefined((String)replacements)) {
            Mutable icsContent = Mutable.of((Object)IOUtils.toString((InputStream)descriptor.getInputStream(), (Charset)Charsets.UTF_8));
            Arrays.stream(replacements.split(";")).map(r -> {
                String[] replacement = r.split("/");
                return Pair.of((Object)replacement[0], (Object)replacement[1]);
            }).forEach(r -> {
                String previous = (String)icsContent.get();
                icsContent.set((Object)previous.replaceAll((String)r.getLeft(), (String)r.getRight()));
            });
            return IOUtils.toInputStream((String)((String)icsContent.get()), (Charset)Charsets.UTF_8);
        }
        return descriptor.getInputStream();
    }

    private CalendarEventOccurrence occurrenceFromICalEvent(CalendarEvent event, VEvent vEvent) {
        Temporal originalStartDate = this.iCal4JDateCodec.decode(vEvent.getRecurrenceId().getDate());
        CalendarEventOccurrence occurrence = CalendarEventOccurrenceBuilder.forEvent(event).startingAt(originalStartDate).endingAt(originalStartDate.plus(1L, ChronoUnit.DAYS)).build();
        occurrence.setPeriod(this.extractPeriod(vEvent));
        this.copyICalEventToComponent(vEvent, occurrence.asCalendarComponent());
        return occurrence;
    }

    private CalendarEvent eventFromICalEvent(String vEventId, VEvent vEvent) {
        Period period = this.extractPeriod(vEvent);
        CalendarEvent event = CalendarEvent.on((Period)period);
        event.withExternalId(vEventId);
        if (vEvent.getClassification() != null) {
            event.withVisibilityLevel(VisibilityLevel.valueOf((String)vEvent.getClassification().getValue()));
        }
        if (vEvent.getProperty("CATEGORIES") != null) {
            Categories categories = (Categories)vEvent.getProperty("CATEGORIES");
            for (String s : categories.getCategories()) {
                event.getCategories().add(s);
            }
        }
        if (vEvent.getProperty("RRULE") != null) {
            Recurrence recurrence = this.iCal4JRecurrenceCodec.decode(vEvent);
            event.recur(recurrence);
        }
        this.copyICalEventToComponent(vEvent, event.asCalendarComponent());
        return event;
    }

    private void copyICalEventToComponent(VEvent vEvent, CalendarComponent component) {
        Property description;
        if (vEvent.getSummary() != null) {
            component.setTitle(vEvent.getSummary().getValue().trim());
        }
        if ((description = vEvent.getProperty("X-ALT-DESC")) == null) {
            description = vEvent.getDescription() != null ? vEvent.getDescription() : new Description("");
        }
        component.setDescription(description.getValue().trim());
        if (vEvent.getLocation() != null) {
            component.setLocation(vEvent.getLocation().getValue().trim());
        }
        if (vEvent.getUrl() != null) {
            component.getAttributes().set("url", vEvent.getUrl().getValue().trim());
        }
        if (vEvent.getPriority() != null) {
            component.setPriority(Priority.fromICalLevel((int)vEvent.getPriority().getLevel()));
        }
        if (vEvent.getCreated() != null) {
            JpaEntityReflection.setCreationData((SilverpeasJpaEntity)component, (User)OperationContext.getFromCache().getUser(), (java.util.Date)vEvent.getCreated().getDate());
        }
        if (vEvent.getLastModified() != null) {
            JpaEntityReflection.setUpdateData((SilverpeasJpaEntity)component, (User)OperationContext.getFromCache().getUser(), (java.util.Date)vEvent.getLastModified().getDate());
        }
    }

    private Period extractPeriod(VEvent vEvent) {
        Date startDate = vEvent.getStartDate().getDate();
        Date endDate = vEvent.getEndDate().getDate();
        if (endDate == null && !(startDate instanceof DateTime)) {
            endDate = startDate;
        }
        Temporal startTemporal = this.iCal4JDateCodec.decode(startDate);
        Temporal endTemporal = this.iCal4JDateCodec.decode(endDate);
        if (endTemporal instanceof OffsetDateTime && startTemporal.equals(endTemporal)) {
            endTemporal = endTemporal.plus(1L, ChronoUnit.HOURS);
        }
        return Period.between((Temporal)startTemporal, (Temporal)endTemporal);
    }
}

