/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user;

import java.util.Date;
import java.util.List;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Bean
public class UserIndexation {
    public static final String COMPONENT_ID = "users";
    public static final String OBJECT_TYPE = "UserFull";

    private UserIndexation() {
    }

    public void indexUser(String userId) {
        try {
            UserFull user = UserFull.getById(userId);
            if (user != null) {
                FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(COMPONENT_ID, OBJECT_TYPE, userId));
                indexEntry.setLastModificationDate(new Date());
                indexEntry.setTitle(user.getDisplayedName());
                if (!user.hasSensitiveData()) {
                    indexEntry.setPreview(user.getEmailAddress());
                }
                indexEntry.addTextContent(StringUtil.normalizeByRemovingAccent((String)user.getDisplayedName()));
                indexEntry.addField("FirstName", user.getFirstName());
                indexEntry.addField("LastName", user.getLastName());
                indexEntry.addField("DomainId", user.getDomainId());
                indexEntry.addField("AccessLevel", user.getAccessLevel().code());
                String[] propertyNames = user.getPropertiesNames();
                StringBuilder extraValues = new StringBuilder(50);
                for (String propertyName : propertyNames) {
                    DomainProperty property = user.getProperty(propertyName);
                    if (property.isSensitive()) continue;
                    String extraValue = user.getValue(propertyName);
                    indexEntry.addField(propertyName, extraValue);
                    extraValues.append(extraValue);
                    extraValues.append(" ");
                }
                indexEntry.addTextContent(extraValues.toString());
                this.setTemplatesDataIntoIndex(userId, indexEntry);
                IndexEngineProxy.addIndexEntry(indexEntry);
            }
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void setTemplatesDataIntoIndex(String userId, FullIndexEntry indexEntry) {
        PublicationTemplateManager manager = PublicationTemplateManager.getInstance();
        List<PublicationTemplate> templates = manager.getDirectoryTemplates();
        for (PublicationTemplate template : templates) {
            manager.setDataIntoIndex(template.getFileName(), COMPONENT_ID, userId, indexEntry);
        }
    }

    public void unindexUser(String userId) {
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(COMPONENT_ID, OBJECT_TYPE, userId));
        IndexEngineProxy.removeIndexEntry(indexEntry.getPK());
    }
}

