/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.admin.AdminSettings;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.SchedulingInitializer;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class DeleteRemovedSpacesScheduler
extends SchedulingInitializer {
    protected static final String JOB_NAME = "DeleteRemovedSpacesJob";
    private final Job job = new DeleteRemovedSpacesJob();
    @Inject
    private Administration admin;

    @NonNull
    protected String getCron() {
        return AdminSettings.getDeletionOfRemovedSpacesCron();
    }

    @NonNull
    protected Job getJob() {
        return this.job;
    }

    protected boolean isSchedulingEnabled() {
        return AdminSettings.isAutomaticDeletionOfRemovedSpacesEnabled();
    }

    private class DeleteRemovedSpacesJob
    extends Job {
        DeleteRemovedSpacesJob() {
            super(DeleteRemovedSpacesScheduler.JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            if (AdminSettings.isAutomaticDeletionOfRemovedSpacesEnabled()) {
                try {
                    List<SpaceInstLight> allRemovedSpaces = DeleteRemovedSpacesScheduler.this.admin.getRemovedSpaces();
                    LocalDate now = LocalDate.now();
                    for (SpaceInstLight removedSpace : allRemovedSpaces) {
                        LocalDate stateSaveDayDateWithDelay = DateUtil.toLocalDate((Date)removedSpace.getRemovalDate()).plusDays(AdminSettings.getDeletionOfRemovedSpacesDayDelay());
                        if (!stateSaveDayDateWithDelay.isBefore(now) && !stateSaveDayDateWithDelay.isEqual(now)) continue;
                        DeleteRemovedSpacesScheduler.this.admin.deleteSpaceInstById(User.getSystemUser().getId(), removedSpace.getId(), true);
                    }
                }
                catch (AdminException e) {
                    SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
    }
}

