/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.quota.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EnumSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.silverpeas.core.admin.quota.constant.QuotaLoad;
import org.silverpeas.core.admin.quota.constant.QuotaType;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="st_quota")
@NamedQuery(name="Quota.getByTypeAndResourceId", query="select q from Quota q where q.type = :type and q.resourceId = :resourceId")
public class Quota
extends BasicJpaEntity<Quota, UniqueLongIdentifier>
implements Serializable {
    private static final long serialVersionUID = 6564633879921455848L;
    @Column(name="quotaType", nullable=false)
    private String type;
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="minCount", nullable=false)
    private long minCount = 0L;
    @Column(name="maxCount", nullable=false)
    private long maxCount = 0L;
    @Column(name="currentCount", nullable=false)
    private long count = 0L;
    @Column(name="saveDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date saveDate;

    public Quota() {
    }

    public Quota(Quota other) {
        this.type = other.type;
        this.resourceId = other.resourceId;
        this.minCount = other.minCount;
        this.maxCount = other.maxCount;
        this.count = other.count;
        this.saveDate = other.saveDate;
    }

    protected void performBeforePersist() {
        super.performBeforePersist();
        this.performSaveDate();
    }

    protected void performBeforeUpdate() {
        super.performBeforeUpdate();
        this.performSaveDate();
    }

    private void performSaveDate() {
        this.setSaveDate(new Date());
    }

    public boolean exists() {
        return this.getId() != null;
    }

    public void validate() throws QuotaException {
        if (this.getType() == null || !StringUtil.isDefined((String)this.getResourceId())) {
            throw new QuotaException(this, "Bad data", new String[0]);
        }
        this.validateBounds();
    }

    public void validateBounds() throws QuotaException {
        if (this.getMinCount() < 0L || this.getMaxCount() < 0L || this.getMinCount() > this.getMaxCount()) {
            throw new QuotaException(this, "Bad data", new String[0]);
        }
    }

    public QuotaLoad getLoad() {
        QuotaLoad quotaLoad = this.isNotUnlimitedLoad() ? (this.getCount() > this.getMaxCount() ? QuotaLoad.OUT_OF_BOUNDS : (this.getCount() == 0L ? QuotaLoad.EMPTY : (this.getCount() < this.getMinCount() ? QuotaLoad.NOT_ENOUGH : (this.getCount() == this.getMaxCount() ? QuotaLoad.FULL : QuotaLoad.NOT_FULL)))) : QuotaLoad.UNLIMITED;
        return quotaLoad;
    }

    public boolean isNotUnlimitedLoad() {
        return this.getMaxCount() > 0L;
    }

    public boolean isReached() {
        return this.exists() && EnumSet.of(QuotaLoad.FULL, QuotaLoad.OUT_OF_BOUNDS).contains((Object)this.getLoad());
    }

    public BigDecimal getLoadRate() {
        BigDecimal loadRate = !QuotaLoad.UNLIMITED.equals((Object)this.getLoad()) ? new BigDecimal(String.valueOf(this.getCount())).divide(new BigDecimal(String.valueOf(this.getMaxCount())), 20, RoundingMode.HALF_DOWN) : BigDecimal.ZERO;
        return loadRate;
    }

    public BigDecimal getLoadPercentage() {
        return this.getLoadRate().multiply(new BigDecimal(String.valueOf(100))).setScale(2, RoundingMode.HALF_DOWN);
    }

    public void setQuotaId(Long id) {
        this.setId(String.valueOf(id));
    }

    public QuotaType getType() {
        if (this.type == null) {
            return null;
        }
        return QuotaType.valueOf(this.type);
    }

    public void setType(QuotaType type) {
        this.type = type == null ? null : type.name();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public long getMinCount() {
        return this.minCount;
    }

    public void setMinCount(long minCount) {
        this.minCount = minCount;
    }

    public void setMinCount(String minCount) throws QuotaException {
        try {
            this.setMinCount(Long.parseLong(minCount));
        }
        catch (NumberFormatException nfe) {
            throw new QuotaException(this, "Invalid minimal count", new String[0]);
        }
    }

    public long getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(long maxCount) {
        this.maxCount = maxCount;
    }

    public void setMaxCount(String maxCount) throws QuotaException {
        try {
            this.setMaxCount(Long.parseLong(maxCount));
        }
        catch (NumberFormatException nfe) {
            throw new QuotaException(this, "Invalid maximal count", new String[0]);
        }
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public Date getSaveDate() {
        return this.saveDate;
    }

    public void setSaveDate(Date saveDate) {
        this.saveDate = saveDate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Quota infos for ");
        builder.append("resourceId=").append(this.getResourceId()).append(" and ");
        builder.append("type=").append((Object)this.getType()).append(": ");
        if (!this.exists()) {
            builder.append("does not exist");
        } else {
            builder.append("load=").append((Object)this.getLoad()).append(", ");
            builder.append("count=").append(this.getCount()).append(", ");
            builder.append("mincount=").append(this.getMinCount()).append(", ");
            builder.append("maxcount=").append(this.getMaxCount());
        }
        return builder.toString();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

