/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.kernel.util.StringUtil;

public class UserRoleRow {
    private static final int NO_VALUE = -1;
    private int id = -1;
    private int instanceId = -1;
    private String name = null;
    private String roleName = null;
    private String description = null;
    private int isInherited = 0;
    private int objectId = -1;
    private String objectType = null;

    private UserRoleRow() {
    }

    public static UserRoleRow fetch(ResultSet rs) throws SQLException {
        UserRoleRow ur = new UserRoleRow();
        ur.id = rs.getInt(1);
        ur.instanceId = rs.getInt(2);
        ur.name = rs.getString(3);
        ur.roleName = rs.getString(4);
        ur.description = rs.getString(5);
        ur.isInherited = rs.getInt(6);
        ur.objectId = rs.getInt(7);
        ur.objectType = rs.getString(8);
        return ur;
    }

    public static UserRoleRow makeFrom(ProfileInst profileInst) {
        UserRoleRow userRole = new UserRoleRow();
        userRole.id = StringUtil.asInt((String)profileInst.getId(), (int)-1);
        userRole.roleName = profileInst.getName();
        userRole.name = profileInst.getLabel();
        userRole.description = profileInst.getDescription();
        if (profileInst.isInherited()) {
            userRole.isInherited = 1;
        }
        userRole.objectId = StringUtil.asInt((String)profileInst.getObjectId().getId(), (int)-1);
        userRole.objectType = profileInst.getObjectId().getType().getCode();
        return userRole;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("The identifier must not be negative");
        }
        this.id = id;
    }

    public void unsetId() {
        this.id = -1;
    }

    public boolean isIdDefined() {
        return this.id != -1;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getInheritance() {
        return this.isInherited;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public boolean isObjectIdDefined() {
        return this.objectId != -1;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public boolean isInstanceIdNotDefined() {
        return this.instanceId == -1;
    }

    public boolean isObjectTypeDefined() {
        return StringUtil.isDefined((String)this.objectType);
    }
}

