/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.model.LocalizedParameter;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.persistence.InstanceDataRow;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.util.Mutable;

@Repository
public class InstanceDataTable
extends Table<InstanceDataRow> {
    private static final String INSTANCE_DATA_TABLE = "ST_Instance_Data";
    private static final String INSTANCEDATA_COLUMNS = "id,componentId,name,label,value";
    private static final String INSERT_INSTANCEDATA = "insert into ST_Instance_Data(id,componentId,name,label,value) values (?,?,?,?,?)";
    private static final String SELECT_ALL_COMPONENTS_BY_PARAMETER_VALUE = "select id,componentId,name,label,value from ST_Instance_Data where name = ? and value = ? order by id";
    private static final String SELECT_ALL_COMPONENT_PARAMETERS = "select id,componentId,name,label,value from ST_Instance_Data where componentId = ? order by id";
    private static final String UPDATE_INSTANCEDATA = "UPDATE ST_Instance_Data SET value = ? where componentId = ? and name = ?";
    private static final String REMOVE_INSTANCEDATA = "delete from ST_Instance_Data where componentid = ?";

    public InstanceDataTable() {
        super(INSTANCE_DATA_TABLE);
    }

    public void createInstanceData(int componentId, LocalizedParameter parameter) throws SQLException {
        InstanceDataRow idr = new InstanceDataRow();
        idr.id = this.getNextId();
        idr.componentId = componentId;
        idr.name = parameter.getName();
        idr.label = parameter.getLabel();
        idr.value = parameter.getValue();
        this.insertRow(INSERT_INSTANCEDATA, idr);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, InstanceDataRow row) throws SQLException {
        insert.setInt(1, row.id);
        insert.setInt(2, row.componentId);
        insert.setString(3, row.name);
        insert.setString(4, row.label);
        insert.setString(5, row.value);
    }

    public List<Parameter> getAllParametersInComponent(int componentId) throws SQLException {
        return this.getRows(SELECT_ALL_COMPONENT_PARAMETERS, componentId).stream().map(this::asParameter).collect(Collectors.toList());
    }

    private Parameter asParameter(InstanceDataRow row) {
        Parameter param = new Parameter();
        param.setName(row.name);
        param.setValue(row.value);
        param.putLabel(I18NHelper.DEFAULT_LANGUAGE, row.label);
        return param;
    }

    public String getParameterValueByComponentAndParamName(Integer componentId, String paramName, boolean ignoreCase) throws SQLException {
        Mutable result = Mutable.empty();
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"value").from(new String[]{INSTANCE_DATA_TABLE}).where("componentId = ?", new Object[]{componentId});
        if (ignoreCase) {
            query.and("lower(name) = ?", new Object[]{paramName.toLowerCase()});
        } else {
            query.and("name = ?", new Object[]{paramName});
        }
        query.execute(r -> {
            result.set((Object)r.getString(1));
            return null;
        });
        return (String)result.orElse((Object)"");
    }

    public Map<Integer, Map<String, String>> getParameterValuesByComponentAndByParamName(Collection<Integer> componentIds, Collection<String> paramNames) throws SQLException {
        HashMap<Integer, Map<String, String>> result = new HashMap<Integer, Map<String, String>>(componentIds.size());
        JdbcSqlQuery.executeBySplittingOn(componentIds, (idBatch, ignore) -> {
            JdbcSqlQuery query = JdbcSqlQuery.select((String)"componentId,name,value").from(new String[]{INSTANCE_DATA_TABLE}).where("componentId", new Object[0]).in(idBatch);
            if (CollectionUtil.isNotEmpty((Collection)paramNames)) {
                query.and("name", new Object[0]).in(paramNames);
            }
            query.execute(r -> {
                int componentId = r.getInt(1);
                String name = r.getString(2);
                String value = r.getString(3);
                Map parameters = result.computeIfAbsent(componentId, i -> new HashMap());
                parameters.put(name, value);
                return null;
            });
        });
        return result;
    }

    public List<Integer> getComponentIdsWithParameterValue(Parameter param) throws SQLException {
        ArrayList<String> queryParams = new ArrayList<String>();
        queryParams.add(param.getName());
        queryParams.add(param.getValue());
        List rows = this.getRows(SELECT_ALL_COMPONENTS_BY_PARAMETER_VALUE, queryParams);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (InstanceDataRow row : rows) {
            ids.add(row.componentId);
        }
        return ids;
    }

    public void updateInstanceData(int componentId, LocalizedParameter parameter) throws SQLException {
        InstanceDataRow idr = new InstanceDataRow();
        idr.componentId = componentId;
        idr.name = parameter.getName();
        idr.value = parameter.getValue();
        int nbRowUpdated = this.updateRow(UPDATE_INSTANCEDATA, idr);
        if (nbRowUpdated < 1) {
            this.createInstanceData(componentId, parameter);
        }
    }

    public void removeInstanceData(int id) throws SQLException {
        this.updateRelation(REMOVE_INSTANCEDATA, id);
    }

    protected InstanceDataRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchInstanceData(rs);
    }

    protected InstanceDataRow fetchInstanceData(ResultSet rs) throws SQLException {
        InstanceDataRow idr = new InstanceDataRow();
        idr.id = rs.getInt(1);
        idr.componentId = rs.getInt(2);
        idr.name = rs.getString(3);
        idr.label = rs.getString(4);
        idr.value = rs.getString(5);
        return idr;
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, InstanceDataRow row) throws SQLException {
        update.setString(1, row.value);
        update.setInt(2, row.componentId);
        update.setString(3, row.name);
    }
}

