/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.synchro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.silverpeas.kernel.logging.Level;
import org.silverpeas.kernel.logging.SilverLogger;

public class SynchroDomainReport {
    private static final String REPORT_NAME = "DomainSynchro";
    private static final String REPORT_NAMESPACE = "silverpeas.core.admin.domain.synchro.domain";
    private static final String LOG_FORMAT = "[{0}] {1}: {2}";
    public static final int STATE_NOSYNC = 0;
    public static final int STATE_WAITSTART = 1;
    public static final int STATE_STARTED = 2;
    public static final int STATE_ENDED = 3;
    private static Level level;
    private static List<String> messages;
    private static int state;

    private SynchroDomainReport() {
    }

    public static String getReportName() {
        return REPORT_NAME;
    }

    public static void setReportLevel(Level reportLevel) {
        level = reportLevel;
    }

    public static Level getReportLevel() {
        return level != null ? level : Level.WARNING;
    }

    private static synchronized void setState(int iStateCours) {
        if (state < 1 || iStateCours != 1) {
            state = iStateCours;
        }
    }

    public static synchronized int getState() {
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessages() {
        String message = null;
        List<String> list = messages;
        synchronized (list) {
            if (!messages.isEmpty()) {
                message = messages.remove(0);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSynchro() {
        List<String> list = messages;
        synchronized (list) {
            messages.clear();
        }
        SynchroDomainReport.setState(2);
        SynchroDomainReport.info("SynchroDomainReport.startSynchro", "Synchronisation Start");
    }

    public static void stopSynchro() {
        SynchroDomainReport.info("SynchroDomainReport.stopSynchro", "Synchronisation End");
        SynchroDomainReport.setState(3);
    }

    public static void reset() {
        SynchroDomainReport.setState(0);
    }

    public static void waitForStart() {
        SynchroDomainReport.setState(1);
    }

    public static void debug(String classe, String message) {
        if (SynchroDomainReport.isSynchroActive()) {
            SynchroDomainReport.addMessage(Level.DEBUG, SynchroDomainReport.msgFormat(Level.DEBUG, classe, message, null));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).debug(LOG_FORMAT, new Object[]{SynchroDomainReport.getReportName(), classe, message});
        }
    }

    public static void info(String classe, String message) {
        if (SynchroDomainReport.isSynchroActive()) {
            SynchroDomainReport.addMessage(Level.INFO, SynchroDomainReport.msgFormat(Level.INFO, classe, message, null));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).info(LOG_FORMAT, new Object[]{SynchroDomainReport.getReportName(), classe, message});
        }
    }

    public static void warn(String classe, String message) {
        if (SynchroDomainReport.isSynchroActive()) {
            SynchroDomainReport.addMessage(Level.WARNING, SynchroDomainReport.msgFormat(Level.WARNING, classe, message, null));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).warn(LOG_FORMAT, new Object[]{SynchroDomainReport.getReportName(), classe, message});
        }
    }

    public static void error(String classe, String message, Throwable ex) {
        if (SynchroDomainReport.isSynchroActive()) {
            SynchroDomainReport.addMessage(Level.ERROR, SynchroDomainReport.msgFormat(Level.ERROR, classe, message, ex));
            SilverLogger.getLogger((String)REPORT_NAMESPACE).error(LOG_FORMAT, new Object[]{SynchroDomainReport.getReportName(), classe, message}, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addMessage(Level msgLevel, String msg) {
        if (msgLevel.value() >= SynchroDomainReport.getReportLevel().value()) {
            List<String> list = messages;
            synchronized (list) {
                messages.add(msg);
            }
        }
    }

    public static boolean isSynchroActive() {
        return state == 2;
    }

    static String msgFormat(Level level, String from, String msgToTrace, Throwable ex) {
        StringBuilder sb = new StringBuilder();
        switch (level) {
            case DEBUG: {
                sb.append("[DEBUG] ");
                break;
            }
            case INFO: {
                sb.append("[INFO] ");
                break;
            }
            case WARNING: {
                sb.append("[WARN] ");
                break;
            }
            case ERROR: {
                sb.append("[ERROR] ");
                break;
            }
            default: {
                sb.append("[UNKNOWN] ");
            }
        }
        sb.append(msgToTrace);
        if (from != null && from.length() > 0) {
            sb.append(" | From: ").append(from);
        }
        if (ex != null) {
            sb.append(" | !!! EXCEPTION !!! : ").append(ex.getMessage());
        }
        return sb.toString();
    }

    static {
        messages = Collections.synchronizedList(new ArrayList());
        state = 0;
    }
}

