/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.synchro;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.domain.synchro.SynchroGroupManager;
import org.silverpeas.core.admin.domain.synchro.SynchroGroupReport;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class DefaultSynchroGroupManager
implements SynchroGroupManager {
    private final Set<String> synchronizedGroupIds = Collections.synchronizedSet(new HashSet());

    @Override
    public void resetContext() {
        try {
            this.synchronizedGroupIds.clear();
            Administration.get().getSynchronizedGroups().forEach(this::updateContextWith);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void synchronize() {
        Set<String> set = this.synchronizedGroupIds;
        synchronized (set) {
            SynchroGroupReport.startSynchro();
            this.synchronizedGroupIds.forEach(i -> {
                try {
                    Administration.get().synchronizeGroupByRule((String)i, true);
                }
                catch (AdminException e) {
                    SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
                }
            });
            SynchroGroupReport.stopSynchro();
        }
    }

    @Override
    public void updateContextWith(Group group) {
        String groupId = group.getId();
        if (StringUtil.isNotDefined((String)groupId)) {
            throw new IllegalArgumentException("Missing group identifier");
        }
        if (group.isSynchronized()) {
            this.synchronizedGroupIds.add(groupId);
        } else {
            this.synchronizedGroupIds.remove(groupId);
        }
    }

    @Override
    public void removeFromContext(Group group) {
        String groupId = group.getId();
        if (StringUtil.isNotDefined((String)groupId)) {
            throw new IllegalArgumentException("Missing group identifier");
        }
        this.synchronizedGroupIds.remove(groupId);
    }
}

