/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.model;

import org.silverpeas.kernel.bundle.SettingBundle;

public class DomainProperty {
    public static final String PROPERTY_TYPE_STRING = "STRING";
    public static final String PROPERTY_TYPE_USERID = "USERID";
    public static final String PROPERTY_TYPE_BOOLEAN = "BOOLEAN";
    public static final int DEFAULT_MAX_LENGTH = 50;
    public static final String PROPERTY_UPDATE_ALLOWED_ADMIN = "A";
    public static final String PROPERTY_UPDATE_ALLOWED_USER = "U";
    public static final String PROPERTY_UPDATE_NOT_ALLOWED = "N";
    private static final String PROPERTY = "property_";
    private String name = null;
    private String type = "STRING";
    private int maxLength = 50;
    private String mapParameter = null;
    private boolean sensitiveProp;
    private boolean usedToImport = false;
    private String redirectOU = null;
    private String redirectAttribute = null;
    private String updateAllowedTo = "N";
    private String label = null;
    private String description = null;

    public DomainProperty() {
    }

    public DomainProperty(SettingBundle rs, int num) {
        String propPrefix = PROPERTY + num;
        this.name = rs.getString(propPrefix + ".Name");
        this.type = PROPERTY_TYPE_STRING;
        String s = rs.getString(propPrefix + ".Type");
        if (s != null && !s.isEmpty()) {
            if (s.equalsIgnoreCase(PROPERTY_TYPE_USERID)) {
                this.type = PROPERTY_TYPE_USERID;
            } else if (s.equalsIgnoreCase(PROPERTY_TYPE_BOOLEAN)) {
                this.type = PROPERTY_TYPE_BOOLEAN;
            }
        }
        this.maxLength = rs.getInteger(propPrefix + ".MaxLength", 50);
        this.mapParameter = rs.getString(propPrefix + ".MapParameter", null);
        this.sensitiveProp = rs.getBoolean(propPrefix + ".Sensitive", false);
        this.usedToImport = rs.getBoolean(propPrefix + ".UsedToImport", false);
        this.redirectOU = rs.getString(propPrefix + ".RedirectOU", null);
        this.redirectAttribute = rs.getString(propPrefix + ".RedirectAttribute", null);
        this.updateAllowedTo = rs.getString(propPrefix + ".UpdateAllowedTo", PROPERTY_UPDATE_NOT_ALLOWED);
    }

    public void setName(String propertyName) {
        this.name = propertyName;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String propertyType) {
        this.type = propertyType;
    }

    public String getType() {
        return this.type;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMapParameter(String mapParameter) {
        this.mapParameter = mapParameter;
    }

    public String getMapParameter() {
        return this.mapParameter;
    }

    public boolean isSensitive() {
        return this.sensitiveProp;
    }

    public boolean isUsedToImport() {
        return this.usedToImport;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRedirectAttribute() {
        return this.redirectAttribute;
    }

    public String getRedirectOU() {
        return this.redirectOU;
    }

    public boolean isUpdateAllowedToUser() {
        return PROPERTY_UPDATE_ALLOWED_USER.equalsIgnoreCase(this.updateAllowedTo);
    }

    public boolean isUpdateAllowedToAdmin() {
        return PROPERTY_UPDATE_ALLOWED_ADMIN.equalsIgnoreCase(this.updateAllowedTo);
    }
}

