/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.domain.driver.ldapdriver.AbstractLDAPGroup;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUtility;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.kernel.logging.SilverLogger;

public class LDAPGroupUniqueDescriptor
extends AbstractLDAPGroup {
    private static final String LDAPGROUP_UNIQUE_DESCRIPTOR_GET_CHILD_GROUPS_ENTRY = "LDAPGroupUniqueDescriptor.getChildGroupsEntry()";

    private String[] getMemberGroupIds(String lds, String memberId, boolean isGroup) throws AdminException {
        ArrayList<String> groups = new ArrayList<String>();
        LDAPEntry memberEntry = this.getMemberEntry(lds, memberId, isGroup);
        LDAPEntry[] theEntries = LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + LDAPUtility.normalizeFilterValue(memberEntry.getDN()) + "))", this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
        for (int i = 0; i < theEntries.length; ++i) {
            groups.add(LDAPUtility.getFirstAttributeValue(theEntries[i], this.driverSettings.getGroupsIdField()));
        }
        return groups.toArray(new String[0]);
    }

    @Override
    public String[] getGroupMemberGroupIds(String lds, String groupId) throws AdminException {
        return this.getMemberGroupIds(lds, groupId, true);
    }

    @Override
    public String[] getUserMemberGroupIds(String lds, String userId) throws AdminException {
        return this.getMemberGroupIds(lds, userId, false);
    }

    @Override
    protected String[] getUserIds(String lds, LDAPEntry groupEntry) {
        String[] stringVals;
        ArrayList<String> users = new ArrayList<String>();
        for (String stringVal : stringVals = LDAPUtility.getAttributeValues(groupEntry, this.driverSettings.getGroupsMemberField())) {
            try {
                LDAPEntry userEntry = LDAPUtility.getFirstEntryFromSearch(lds, stringVal, this.driverSettings.getScope(), this.driverSettings.getUsersFullFilter(), this.driverSettings.getGroupAttributes());
                String userSpecificId = this.getSpecificId(lds, userEntry);
                if (userSpecificId == null) continue;
                users.add(userSpecificId);
            }
            catch (AdminException e) {
                SilverLogger.getLogger((Object)this).error("USER NOT FOUND : " + LDAPUtility.dblBackSlashesForDNInFilters(stringVal), (Throwable)((Object)e));
            }
        }
        return users.toArray(new String[0]);
    }

    @Override
    protected LDAPEntry[] getChildGroupsEntry(String lds, String parentId, String extraFilter) throws AdminException {
        List<Object> entries = new ArrayList();
        try {
            if (parentId != null && !parentId.isEmpty()) {
                LDAPEntry theEntry = this.getGroupEntry(lds, parentId);
                String[] stringVals = LDAPUtility.getAttributeValues(theEntry, this.driverSettings.getGroupsMemberField());
                entries = Stream.of(stringVals).map(v -> this.findGroupEntry(lds, (String)v, extraFilter)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            } else {
                Object theFilter = extraFilter != null && !extraFilter.isEmpty() ? "(&" + extraFilter + this.driverSettings.getGroupsFullFilter() + ")" : this.driverSettings.getGroupsFullFilter();
                LDAPEntry[] theEntries = LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), (String)theFilter, this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
                SynchroDomainReport.debug(LDAPGROUP_UNIQUE_DESCRIPTOR_GET_CHILD_GROUPS_ENTRY, "R\u00e9cup\u00e9ration de " + theEntries.length + " groupes en tout, recherche des groupes racine...");
                entries = Stream.of(theEntries).map(e -> this.findGroupWithMember(lds, (LDAPEntry)e).orElse((LDAPEntry)e)).collect(Collectors.toList());
            }
        }
        catch (AdminException e2) {
            if (this.synchroInProcess) {
                SilverLogger.getLogger((Object)this).error((Throwable)((Object)e2));
                this.append("PB getting Group's subgroups : ").append(parentId).append("\n");
                if (parentId == null) {
                    SynchroDomainReport.error(LDAPGROUP_UNIQUE_DESCRIPTOR_GET_CHILD_GROUPS_ENTRY, "Erreur lors de la r\u00e9cup\u00e9ration des groupes racine", (Throwable)((Object)e2));
                } else {
                    SynchroDomainReport.error(LDAPGROUP_UNIQUE_DESCRIPTOR_GET_CHILD_GROUPS_ENTRY, "Erreur lors de la r\u00e9cup\u00e9ration des groupes fils du groupe " + parentId, (Throwable)((Object)e2));
                }
            }
            throw e2;
        }
        return entries.toArray(new LDAPEntry[0]);
    }

    private Optional<LDAPEntry> findGroupWithMember(String lds, LDAPEntry theEntry) {
        try {
            return Optional.ofNullable(LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + LDAPUtility.normalizeFilterValue(theEntry.getDN()) + "))", this.driverSettings.getGroupAttributes()));
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error("IS ROOT GROUP ? : " + theEntry.getDN(), (Throwable)((Object)e));
            return Optional.empty();
        }
    }

    private Optional<LDAPEntry> findGroupEntry(String lds, String stringVal, String extraFilter) {
        try {
            Object theFilter = extraFilter != null && !extraFilter.isEmpty() ? "(&" + extraFilter + this.driverSettings.getGroupsFullFilter() + ")" : this.driverSettings.getGroupsFullFilter();
            LDAPEntry childGroupEntry = LDAPUtility.getFirstEntryFromSearch(lds, stringVal, this.driverSettings.getScope(), (String)theFilter, this.driverSettings.getGroupAttributes());
            if (childGroupEntry != null) {
                String groupSpecificId = LDAPUtility.getFirstAttributeValue(childGroupEntry, this.driverSettings.getGroupsIdField());
                if (LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(groupSpecificId), this.driverSettings.getGroupAttributes()) != null) {
                    return Optional.of(childGroupEntry);
                }
            }
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error("GROUP NOT FOUND : " + stringVal, (Throwable)((Object)e));
        }
        return Optional.empty();
    }
}

