/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import java.util.stream.Stream;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.SilverpeasResourcesLocation;
import org.silverpeas.kernel.annotation.NonNull;

public class DomainDescriptor {
    private final Path domainPath;
    private final Path authPath;
    private final Properties domainProperties = new Properties();
    private final Properties authProperties = new Properties();

    public DomainDescriptor(String domainName) {
        Path silverpeasConfigRoot = SilverpeasResourcesLocation.getInstance().getConfigurationFilesRootPath();
        this.domainPath = silverpeasConfigRoot.resolve(Path.of("org", "silverpeas", "domains", "domain" + domainName + ".properties"));
        this.authPath = silverpeasConfigRoot.resolve(Path.of("org", "silverpeas", "authentication", "autDomain" + domainName + ".properties"));
    }

    public void loadDomainProperties() throws UncheckedIOException {
        try (BufferedReader reader = Files.newBufferedReader(this.domainPath);){
            this.domainProperties.load(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void loadAuthenticationProperties() throws UncheckedIOException {
        try (BufferedReader reader = Files.newBufferedReader(this.authPath);){
            this.authProperties.load(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NonNull
    public Properties getDomainProperties() {
        return this.domainProperties;
    }

    @NonNull
    public Properties getAuthenticationProperties() {
        return this.authProperties;
    }

    public void updateDomainProperties(Properties domainProperties) throws UncheckedIOException {
        if (domainProperties != null && !domainProperties.isEmpty()) {
            this.update(this.domainPath, domainProperties);
        }
    }

    public void updateAuthenticationProperties(Properties authProperties) throws UncheckedIOException {
        if (authProperties != null && !authProperties.isEmpty()) {
            this.update(this.authPath, authProperties);
        }
    }

    private void update(Path propertiesFile, Properties properties) throws UncheckedIOException {
        Path tmpPath = propertiesFile.getParent().resolve(propertiesFile.toFile().getName() + ".tmp");
        try (PrintWriter writer = new PrintWriter(tmpPath.toFile(), Charsets.ISO_8859_1);
             Stream<String> lines = Files.lines(propertiesFile, Charsets.ISO_8859_1);){
            lines.forEach(line -> {
                if (line.contains("=")) {
                    String key = line.substring(0, line.indexOf("=")).trim();
                    String value = properties.getProperty(key);
                    if (value != null) {
                        writer.println(key + "=" + value);
                    } else {
                        writer.println((String)line);
                    }
                } else {
                    writer.println((String)line);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            FileUtil.copyFile(tmpPath.toFile(), propertiesFile.toFile());
            Files.deleteIfExists(tmpPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

