/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.silverpeas.core.admin.component.PersonalComponentRegistry;
import org.silverpeas.core.admin.component.model.AbstractSilverpeasComponent;
import org.silverpeas.core.admin.component.model.GroupOfParameters;
import org.silverpeas.core.admin.component.model.MultilangHashMapAdapter;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PersonalComponentType", propOrder={"name", "label", "description", "visible", "groupsOfParameters", "parameters"})
public class PersonalComponent
extends AbstractSilverpeasComponent {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected Map<String, String> label;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected Map<String, String> description;
    @XmlElement(required=true)
    protected boolean visible;
    @XmlElementWrapper(name="groupsOfParameters")
    @XmlElement(name="groupOfParameters")
    protected List<GroupOfParameters> groupsOfParameters;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    protected List<Parameter> parameters;

    public static Optional<PersonalComponent> getByName(String componentName) {
        return PersonalComponentRegistry.get().getPersonalComponent(componentName);
    }

    public static Optional<PersonalComponent> getByInstanceId(String componentInstanceId) {
        return PersonalComponent.getByName(PersonalComponentInstance.getComponentName(componentInstanceId));
    }

    public static Collection<PersonalComponent> getAll() {
        return PersonalComponentRegistry.get().getAllPersonalComponents().values();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected Map<String, String> getLabel() {
        if (this.label == null) {
            this.label = new HashMap<String, String>();
        }
        return this.label;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setLabel(Map<String, String> value) {
        this.label = value;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isPersonal() {
        return true;
    }

    public void setDescription(Map<String, String> value) {
        this.description = value;
    }

    @Override
    protected Map<String, String> getDescription() {
        if (this.description == null) {
            this.description = new HashMap<String, String>();
        }
        return this.description;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    @Override
    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.indexedParametersByName.clear();
    }

    @Override
    public boolean hasParameterDefined(String parameterName) {
        return this.getIndexedParametersByName().get(parameterName) != null;
    }

    @Override
    public List<GroupOfParameters> getGroupsOfParameters() {
        if (this.groupsOfParameters == null) {
            this.groupsOfParameters = new ArrayList<GroupOfParameters>();
        }
        return this.groupsOfParameters;
    }
}

