/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.Tool;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class ToolRegistry
implements Initialization {
    private final Map<String, Tool> toolsById = new HashMap<String, Tool>();

    ToolRegistry() {
    }

    public static ToolRegistry get() {
        return (ToolRegistry)ServiceProvider.getService(ToolRegistry.class, (Annotation[])new Annotation[0]);
    }

    public void init() {
        Stream.of(ResourceLocator.getGeneralSettingBundle().getString("availableToolIds", "")).flatMap(s -> Stream.of(s.split("[ ,;]"))).filter(StringUtil::isDefined).forEach(t -> this.toolsById.put((String)t, new Tool((String)t)));
    }

    public Optional<Tool> getTool(String toolId) {
        return Optional.ofNullable(this.toolsById.get(toolId));
    }

    public Map<String, Tool> getAllTools() {
        return Collections.unmodifiableMap(this.toolsById);
    }
}

