/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectType;

public class ProfiledObjectIds
extends ArrayList<String> {
    private static final long serialVersionUID = 1105782427397730734L;
    private final ProfiledObjectType type;
    private boolean typeFilledOnly = false;

    private ProfiledObjectIds(ProfiledObjectType type) {
        this.type = type;
    }

    private ProfiledObjectIds(ProfiledObjectType type, Collection<String> objectIds) {
        this.type = type;
        this.addAll(objectIds);
    }

    private ProfiledObjectIds(Collection<String> objectIds, ProfiledObjectType type) {
        this.type = type;
        this.addAll(objectIds);
    }

    public static ProfiledObjectIds none() {
        return new ProfiledObjectIds(ProfiledObjectType.NONE);
    }

    public static ProfiledObjectIds ofType(ProfiledObjectType profiledObjectType) {
        ProfiledObjectIds type = new ProfiledObjectIds(Collections.emptyList(), profiledObjectType);
        type.typeFilledOnly = true;
        return type;
    }

    public static ProfiledObjectIds fromProfileObjectId(ProfiledObjectId profiledObjectId) {
        return new ProfiledObjectIds(profiledObjectId.getType(), Collections.singleton(profiledObjectId.getId()));
    }

    public static ProfiledObjectIds fromNodeIds(Collection<String> nodeIds) {
        return new ProfiledObjectIds(nodeIds, ProfiledObjectType.NODE);
    }

    public ProfiledObjectType getType() {
        return this.type;
    }

    public boolean typeFilledOnly() {
        return this.isEmpty() && this.typeFilledOnly;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProfiledObjectIds strings = (ProfiledObjectIds)o;
        return this.type == strings.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }
}

