/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.publication;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.SpaceWithSubSpacesAndComponents;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.publication.model.CompletePublication;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationLink;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.NodeAccessController;
import org.silverpeas.core.security.authorization.PublicationAccessController;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.attachment.AttachmentEntity;
import org.silverpeas.core.webapi.publication.AbstractPublicationResource;
import org.silverpeas.core.webapi.publication.LocationEntity;
import org.silverpeas.core.webapi.publication.PublicationEntity;
import org.silverpeas.kernel.logging.SilverLogger;

@WebService
@Path(value="private/publications/{componentId}")
@Authorized
public class PublicationResource
extends AbstractPublicationResource {
    static final String PATH = "private/publications";
    @PathParam(value="componentId")
    protected String componentId;
    @Inject
    private NodeAccessController nodeAccessController;
    @Inject
    private PublicationAccessController publicationAccessController;

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.componentId;
    }

    @GET
    @Produces(value={"application/json"})
    public List<PublicationEntity> listPublications(@QueryParam(value="node") String nodeId, @QueryParam(value="withAttachments") boolean withAttachments) {
        List<PublicationEntity> publications = this.getPublications(nodeId, true, withAttachments);
        this.setURIToAttachments(publications);
        return publications;
    }

    @DELETE
    @Path(value="{pubId}/links/{linkId}")
    @Produces(value={"application/json"})
    public Response deleteLink(@PathParam(value="pubId") String pubId, @PathParam(value="linkId") String linkId) {
        PublicationPK pk = new PublicationPK(pubId, this.componentId);
        CompletePublication publication = this.getPublicationService().getCompletePublication(pk);
        if (publication == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.publicationAccessController.isUserAuthorized(this.getUser().getId(), pk, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}))) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        List links = publication.getLinkList();
        for (PublicationLink link : links) {
            if (!link.getId().equals(linkId)) continue;
            this.getPublicationService().deleteLink(linkId);
            return Response.ok().build();
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="{pubId}/locations")
    @Produces(value={"application/json"})
    public List<LocationEntity> getLocations(@PathParam(value="pubId") String pubId, @QueryParam(value="lang") String language) {
        PublicationPK pk = new PublicationPK(pubId, this.componentId);
        String uri = this.getUri().getAbsolutePath().toString();
        uri = uri.replace("/locations", "");
        ArrayList<LocationEntity> entities = new ArrayList<LocationEntity>();
        List locations = this.getPublicationService().getAllLocations(pk);
        List<Location> sortedLocations = new ArrayList();
        try {
            SpaceWithSubSpacesAndComponents treeView = OrganizationController.get().getFullTreeview(this.getUser().getId());
            List compos = treeView.componentInstanceSelector().fromAllSpaces().select();
            for (SilverpeasComponentInstance compo : compos) {
                sortedLocations.addAll(this.getComponentLocations(locations, compo.getId()));
            }
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            sortedLocations = locations;
        }
        for (Location location : sortedLocations) {
            entities.add(LocationEntity.fromLocation(location, UriBuilder.fromUri((String)uri).build(new Object[0]), language));
        }
        return entities;
    }

    private List<Location> getComponentLocations(List<Location> allLocations, String componentId) {
        ArrayList<Location> componentLocations = new ArrayList<Location>();
        for (Location location : allLocations) {
            if (!location.getInstanceId().equals(componentId)) continue;
            componentLocations.add(location);
        }
        return componentLocations;
    }

    @PUT
    @Path(value="{pubId}/locations/{nodeId}-{aliasComponentId}")
    @Produces(value={"application/json"})
    public Response addAlias(@PathParam(value="pubId") String pubId, @PathParam(value="nodeId") String nodeId, @PathParam(value="aliasComponentId") String aliasComponentId) {
        PublicationPK pk = new PublicationPK(pubId, this.componentId);
        if (!this.publicationAccessController.isUserAuthorized(this.getUser().getId(), pk, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}))) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Location location = new Location(nodeId, aliasComponentId);
        location.setAsAlias(User.getCurrentRequester().getId());
        this.getPublicationService().addAliases(pk, Collections.singletonList(location));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{pubId}/locations/{nodeId}-{aliasComponentId}")
    @Produces(value={"application/json"})
    public Response deleteAlias(@PathParam(value="pubId") String pubId, @PathParam(value="nodeId") String nodeId, @PathParam(value="aliasComponentId") String aliasComponentId) {
        PublicationPK pk = new PublicationPK(pubId, this.componentId);
        if (!this.publicationAccessController.isUserAuthorized(this.getUser().getId(), pk, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}))) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        List aliases = this.getPublicationService().getAllAliases(pk);
        for (Location alias : aliases) {
            if (!alias.getId().equals(nodeId) || !alias.getInstanceId().equals(aliasComponentId)) continue;
            this.getPublicationService().removeAliases(pk, Collections.singletonList(alias));
        }
        return Response.ok().build();
    }

    private void setURIToAttachments(List<PublicationEntity> publications) {
        if (publications != null) {
            for (PublicationEntity publication : publications) {
                List<AttachmentEntity> attachments = publication.getAttachments();
                if (attachments == null) continue;
                for (AttachmentEntity attachment : attachments) {
                    attachment.withBaseUri(this.getUri().getBaseUri().toString());
                }
            }
        }
    }

    @Override
    protected boolean isNodeReadable(NodePK nodePK) {
        return this.nodeAccessController.isUserAuthorized(super.getUser().getId(), (Object)nodePK);
    }

    protected URI identifiedBy(URI uri) {
        return uri;
    }
}

