/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.ClassifyValue;
import org.silverpeas.core.pdc.pdc.model.PdcAxisValue;
import org.silverpeas.core.pdc.pdc.model.PdcPosition;
import org.silverpeas.core.pdc.thesaurus.model.ThesaurusException;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.pdc.PdcPositionValueEntity;
import org.silverpeas.core.webapi.pdc.UserThesaurusHolder;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PdcPositionEntity
implements WebEntity {
    private static final long serialVersionUID = 6314816355055147378L;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) List<PdcPositionValueEntity> values = new ArrayList<PdcPositionValueEntity>();
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private String id;

    public static PdcPositionEntity fromClassifyPosition(ClassifyPosition position, String inLanguage, URI inClassificationByURI) {
        String positionId = String.valueOf(position.getPositionId());
        return new PdcPositionEntity(PdcPositionEntity.fromClassifyValues(position.getListClassifyValue(), inLanguage)).withURI(inClassificationByURI, positionId).withId(positionId);
    }

    public static PdcPositionEntity fromPdcPosition(PdcPosition position, String inLanguage, URI inClassificationByURI) {
        return new PdcPositionEntity(PdcPositionEntity.fromPdcAxisValues(position.getValues(), inLanguage)).withURI(inClassificationByURI, position.getId()).withId(position.getId());
    }

    public static PdcPositionEntity createNewPositionWith(List<PdcPositionValueEntity> values) {
        return new PdcPositionEntity(values);
    }

    public ClassifyPosition toClassifyPosition() {
        ArrayList<ClassifyValue> classifyValues = new ArrayList<ClassifyValue>(this.values.size());
        for (PdcPositionValueEntity value : this.values) {
            classifyValues.add(value.toClassifyValue());
        }
        int positionId = -1;
        if (StringUtil.isDefined((String)this.id)) {
            positionId = Integer.valueOf(this.id);
        }
        return new ClassifyPosition(positionId, classifyValues);
    }

    public PdcPosition toPdcPosition() {
        PdcPosition position = new PdcPosition().withId(this.id);
        for (PdcPositionValueEntity valueEntity : this.values) {
            position.getValues().add(valueEntity.toPdcAxisValue());
        }
        return position;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public List<PdcPositionValueEntity> getPositionValues() {
        return Collections.unmodifiableList(this.values);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdcPositionEntity other = (PdcPositionEntity)obj;
        if (!(this.uri == other.uri || this.uri != null && this.uri.equals(other.uri))) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.values == other.values || this.values != null && this.values.equals(other.values);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.values != null ? this.values.hashCode() : 0);
        hash = 79 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 79 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder valueArray = new StringBuilder("[");
        for (PdcPositionValueEntity pdcPositionValue : this.getPositionValues()) {
            valueArray.append(pdcPositionValue.toString()).append(", ");
        }
        if (valueArray.length() > 1) {
            valueArray.replace(valueArray.length() - 2, valueArray.length(), "]");
        } else {
            valueArray.append("]");
        }
        String uriAsStr = "";
        if (this.getURI() != null) {
            uriAsStr = this.getURI().toString();
        }
        return "PdcPositionEntity{id=" + this.getId() + ", uri=" + uriAsStr + ", values=" + valueArray.toString() + "}";
    }

    private static List<PdcPositionValueEntity> fromClassifyValues(List<ClassifyValue> values, String inLanguage) {
        ArrayList<PdcPositionValueEntity> positionValues = new ArrayList<PdcPositionValueEntity>(values.size());
        for (ClassifyValue value : values) {
            positionValues.add(PdcPositionValueEntity.fromClassifiyValue(value, inLanguage));
        }
        return positionValues;
    }

    private static List<PdcPositionValueEntity> fromPdcAxisValues(Collection<PdcAxisValue> values, String inLanguage) {
        ArrayList<PdcPositionValueEntity> positionValues = new ArrayList<PdcPositionValueEntity>(values.size());
        for (PdcAxisValue value : values) {
            positionValues.add(PdcPositionValueEntity.fromPdcAxisValue(value, inLanguage));
        }
        return positionValues;
    }

    private PdcPositionEntity() {
    }

    protected PdcPositionEntity(List<PdcPositionValueEntity> values) {
        this.setPositionValues(values);
    }

    protected void setSynonymsFrom(UserThesaurusHolder userThesaurus) throws ThesaurusException {
        for (PdcPositionValueEntity pdcPositionValue : this.values) {
            pdcPositionValue.setSynonyms(userThesaurus.getSynonymsOf(pdcPositionValue));
        }
    }

    private PdcPositionEntity withURI(URI baseURI, String positionId) {
        String positionPath = "/" + positionId;
        String query = baseURI.getRawQuery();
        if (!StringUtil.isDefined((String)query)) {
            this.uri = URI.create(baseURI.toString() + positionPath);
        } else {
            String requestURI = baseURI.toString();
            this.uri = URI.create(requestURI.substring(0, requestURI.lastIndexOf("?")) + positionPath + "?" + query);
        }
        return this;
    }

    private PdcPositionEntity withId(String id) {
        this.id = id;
        return this;
    }

    private void setPositionValues(List<PdcPositionValueEntity> values) {
        this.values.clear();
        this.values.addAll(values);
    }
}

