/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.mylinks;

import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.mylinks.model.LinkDetail;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.mylinks.CategoryEntity;
import org.silverpeas.core.webapi.mylinks.CategoryPosition;
import org.silverpeas.core.webapi.mylinks.MyLinkEntity;
import org.silverpeas.core.webapi.mylinks.MyLinkPosition;
import org.silverpeas.core.webapi.mylinks.MyLinksResourceURIs;
import org.silverpeas.core.webapi.mylinks.MyLinksWebManager;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="mylinks")
@Authenticated
public class MyLinksResource
extends RESTWebService {
    static final String PATH = "mylinks";
    @Inject
    private MyLinksResourceURIs uri;
    @Inject
    private MyLinksWebManager manager;

    protected String getResourceBasePath() {
        return PATH;
    }

    @GET
    @Path(value="categories")
    @Produces(value={"application/json"})
    public List<CategoryEntity> getAllCategoriesOfUser() {
        return this.manager.getAllCategoriesOfCurrentUser().stream().map(this::toWebEntity).collect(Collectors.toList());
    }

    @GET
    @Path(value="categories/{catId}")
    @Produces(value={"application/json"})
    public CategoryEntity getCategory(@PathParam(value="catId") String catId) {
        return this.toWebEntity(this.manager.getAuthorizedCategory(catId));
    }

    @POST
    @Path(value="categories")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CategoryEntity addCategory(CategoryEntity newCategory) {
        return this.toWebEntity(this.manager.createCategory(newCategory));
    }

    @PUT
    @Path(value="categories/{catId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CategoryEntity updateCategory(@PathParam(value="catId") String catId, CategoryEntity updatedCategory) {
        this.verifyConsistency(catId, updatedCategory);
        return this.toWebEntity(this.manager.updateCategory(updatedCategory));
    }

    @DELETE
    @Path(value="categories/{catId}")
    @Produces(value={"application/json"})
    public Response deleteCategory(@PathParam(value="catId") String catId) {
        this.manager.deleteCategories(new String[]{catId});
        return Response.ok().build();
    }

    @POST
    @Path(value="categories/saveLinesOrder")
    @Consumes(value={"application/json"})
    public Response saveUserCategoriesOrder(CategoryPosition categoryPosition) {
        if (categoryPosition == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.manager.getAuthorizedCategory(String.valueOf(categoryPosition.getCatId()));
        List<CategoryDetail> categoryToManage = this.manager.getAllCategoriesOfCurrentUser();
        this.performPositionUpdate(categoryPosition.getCatId(), categoryPosition.getPosition(), categoryToManage.stream(), CategoryDetail::getId, CategoryDetail::hasPosition, CategoryDetail::getPosition, (c, p) -> {
            c.setHasPosition(true);
            c.setPosition(p);
            this.manager.updateCategory(this.toWebEntity((CategoryDetail)c));
        });
        return Response.ok((Object)this.getCategory(String.valueOf(categoryPosition.getCatId()))).build();
    }

    @GET
    @Produces(value={"application/json"})
    public List<MyLinkEntity> getMyLinks() {
        return this.manager.getAllLinksOfCurrentUser().stream().filter(LinkDetail::isVisible).map(this::toWebEntity).collect(Collectors.toList());
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public MyLinkEntity getLink(@PathParam(value="id") String linkId) {
        return this.toWebEntity(this.manager.getAuthorizedLink(linkId));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public MyLinkEntity addLink(MyLinkEntity newLink) {
        return this.toWebEntity(this.manager.createLink(newLink));
    }

    @PUT
    @Path(value="{linkId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public MyLinkEntity updateLink(@PathParam(value="linkId") String linkId, MyLinkEntity updatedLink) {
        this.verifyConsistency(linkId, updatedLink);
        return this.toWebEntity(this.manager.updateLink(updatedLink));
    }

    @DELETE
    @Path(value="{linkId}")
    @Produces(value={"application/json"})
    public Response deleteLink(@PathParam(value="linkId") String linkId) {
        this.manager.deleteLinks(new String[]{linkId});
        return Response.ok().build();
    }

    @POST
    @Path(value="saveLinesOrder")
    @Consumes(value={"application/json"})
    public Response saveUserLinksOrder(MyLinkPosition linkPosition) {
        if (linkPosition == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        LinkDetail linkOfPosition = this.manager.getAuthorizedLink(String.valueOf(linkPosition.getLinkId()));
        List<LinkDetail> linksToManage = StringUtil.isDefined((String)linkOfPosition.getObjectId()) ? this.manager.getAllLinksOfResourceOnInstance(linkOfPosition.getObjectId(), linkOfPosition.getInstanceId()) : (StringUtil.isDefined((String)linkOfPosition.getInstanceId()) ? this.manager.getAllLinksOfInstance(linkOfPosition.getInstanceId()) : this.manager.getAllLinksOfCurrentUser());
        this.performPositionUpdate(linkPosition.getLinkId(), linkPosition.getPosition(), linksToManage.stream().filter(l -> this.sameCategoryFilter(linkOfPosition.getCategory(), l.getCategory())), LinkDetail::getLinkId, LinkDetail::hasPosition, LinkDetail::getPosition, (l, p) -> {
            l.setHasPosition(true);
            l.setPosition(p);
            this.manager.updateLink(this.toWebEntity((LinkDetail)l));
        });
        return Response.ok((Object)this.getLink(String.valueOf(linkPosition.getLinkId()))).build();
    }

    private <T> void performPositionUpdate(int targetIdentifier, int targetPosition, Stream<T> details, ToIntFunction<T> identifier, Predicate<T> hasPosition, ToIntFunction<T> getPosition, ObjIntConsumer<T> updater) {
        Mutable position = Mutable.of((Object)-1);
        details.forEach(d -> {
            int finalPosition;
            if (identifier.applyAsInt(d) == targetIdentifier) {
                finalPosition = targetPosition;
            } else {
                position.set((Object)((Integer)position.get() + 1));
                if ((Integer)position.get() == targetPosition) {
                    position.set((Object)((Integer)position.get() + 1));
                }
                finalPosition = (Integer)position.get();
            }
            if (!hasPosition.test(d) || getPosition.applyAsInt(d) != finalPosition) {
                updater.accept(d, finalPosition);
            }
        });
    }

    private boolean sameCategoryFilter(CategoryDetail ref, CategoryDetail category) {
        if (ref == null) {
            return category == null;
        }
        return ref.equals((Object)category);
    }

    private void verifyConsistency(String linkId, MyLinkEntity updatedLink) {
        if (StringUtil.isNotDefined((String)linkId) || !linkId.equals(String.valueOf(updatedLink.getLinkId()))) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    private void verifyConsistency(String catId, CategoryEntity updatedCategory) {
        if (StringUtil.isNotDefined((String)catId) || !catId.equals(String.valueOf(updatedCategory.getCategoryId()))) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    public String getComponentId() {
        return null;
    }

    private MyLinkEntity toWebEntity(LinkDetail linkDetail) {
        return MyLinkEntity.fromLinkDetail(linkDetail, this.uri.ofLink(linkDetail));
    }

    private CategoryEntity toWebEntity(CategoryDetail categoryDetail) {
        return CategoryEntity.fromCategoryDetail(categoryDetail, this.uri.ofCategory(categoryDetail));
    }
}

