/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.documenttemplate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.documenttemplate.DocumentTemplateRuntimeException;
import org.silverpeas.core.documenttemplate.DocumentTemplateService;
import org.silverpeas.core.documenttemplate.DocumentTemplateSettings;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.MemoizedSyncSupplier;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.viewer.service.PreviewService;
import org.silverpeas.core.viewer.service.ViewService;
import org.silverpeas.core.viewer.service.ViewerContext;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class DocumentTemplateWebManager {
    @Inject
    private DocumentTemplateService service;
    private final MemoizedSyncSupplier<List<DocumentTemplate>> cachedList = new MemoizedSyncSupplier(() -> DocumentTemplateSettings.isEnabled() ? this.service.listAll() : List.of());

    protected DocumentTemplateWebManager() {
    }

    public static DocumentTemplateWebManager get() {
        return (DocumentTemplateWebManager)ServiceProvider.getService(DocumentTemplateWebManager.class, (Annotation[])new Annotation[0]);
    }

    public DocumentTemplate getDocumentTemplate(String id) {
        if (StringUtil.isNotDefined((String)id)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return (DocumentTemplate)this.service.getById(id).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
    }

    public void createDocumentTemplate(DocumentTemplate newDocumentTemplate, UploadedFile content) {
        try (FileInputStream is = FileUtils.openInputStream((File)content.getFile());){
            DocumentTemplate created = this.service.put(newDocumentTemplate, (InputStream)is);
            this.clearCachedList();
            LocalizationBundle bundle = this.getBundle();
            this.getMessager().addSuccess(bundle.getString("documentTemplate.create.success"), created.getName(bundle.getLocale().getLanguage()));
        }
        catch (IOException | DocumentTemplateRuntimeException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    public void updateDocumentTemplate(DocumentTemplate updatedDocumentTemplate, UploadedFile content) {
        try (FileInputStream is = content != null ? FileUtils.openInputStream((File)content.getFile()) : null;){
            DocumentTemplate previous = this.service.getById(updatedDocumentTemplate.getId()).orElseGet(DocumentTemplate::new);
            DocumentTemplate updated = this.service.put(updatedDocumentTemplate, (InputStream)is);
            DisplayI18NHelper.getLanguages().forEach(l -> {
                if (!previous.getName(l).equals(updated.getName(l))) {
                    ViewerContext viewerContext = updated.getViewerContext(l);
                    PreviewService.get().removePreview(viewerContext);
                    ViewService.get().removeDocumentView(viewerContext);
                }
            });
            this.clearCachedList();
            LocalizationBundle bundle = this.getBundle();
            this.getMessager().addSuccess(bundle.getString("documentTemplate.update.success"), updated.getName(bundle.getLocale().getLanguage()));
        }
        catch (IOException | DocumentTemplateRuntimeException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    public void deleteDocumentTemplates(List<String> documentTemplateIds) {
        if (!documentTemplateIds.isEmpty()) {
            List<DocumentTemplate> documentTemplates = documentTemplateIds.stream().map(this::getDocumentTemplate).collect(Collectors.toList());
            documentTemplates.forEach(arg_0 -> ((DocumentTemplateService)this.service).remove(arg_0));
            this.clearCachedList();
            LocalizationBundle bundle = this.getBundle();
            if (documentTemplateIds.size() == 1) {
                this.getMessager().addSuccess(bundle.getString("documentTemplate.delete.success"), documentTemplates.stream().map(t -> t.getName(bundle.getLocale().getLanguage())).findFirst().orElse(""));
            } else {
                this.getMessager().addSuccess(bundle.getString("documentTemplates.delete.success"), new Object[0]);
            }
        }
    }

    public void sortDocumentTemplates(List<String> sortedDocumentTemplateIds) {
        AtomicInteger index = new AtomicInteger(0);
        Map<String, Integer> newPositions = sortedDocumentTemplateIds.stream().collect(Collectors.toMap(i -> i, i -> index.getAndIncrement()));
        this.clearCachedList();
        List<DocumentTemplate> updated = this.getAllDocumentTemplates().stream().filter(t -> {
            Integer newPosition = (Integer)newPositions.get(t.getId());
            if (newPosition == null) {
                this.getMessager().addInfo(this.getBundle().getString("documentTemplates.list.changed.already"), new Object[0]);
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
            if (!newPosition.equals(t.getPosition())) {
                t.setPosition(newPosition.intValue());
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (!updated.isEmpty()) {
            this.clearCachedList();
            updated.forEach(t -> this.service.put(t, null));
            this.getMessager().addSuccess(this.getBundle().getString("documentTemplates.sort.success"), new Object[0]);
        }
    }

    public void clearCachedList() {
        this.cachedList.clear();
    }

    public List<DocumentTemplate> getAllDocumentTemplates() {
        return (List)this.cachedList.get();
    }

    public boolean existsDocumentTemplate() {
        return !((List)this.cachedList.get()).isEmpty();
    }

    private LocalizationBundle getBundle() {
        User owner = User.getCurrentRequester();
        String userLanguage = owner.getUserPreferences().getLanguage();
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.documentTemplate.multilang.documentTemplate", (String)userLanguage);
    }

    private WebMessager getMessager() {
        return WebMessager.getInstance();
    }
}

