/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarReference;
import org.silverpeas.core.importexport.ExportDescriptor;
import org.silverpeas.core.importexport.ExportException;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.security.token.persistent.PersistentResourceToken;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.webapi.calendar.CalendarWebManager;
import org.silverpeas.kernel.logging.SilverLogger;

@WebService
@Path(value="calendar/ical")
public class ICalendarResource
extends RESTWebService {
    static final String PATH = "calendar/ical";

    protected String getResourceBasePath() {
        return PATH;
    }

    @HEAD
    @Path(value="public/{calendarId}")
    public Response getCalendarHead(@PathParam(value="calendarId") String calendarId) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)calendar);
        return this.exportHeadOnly(calendar, true);
    }

    @GET
    @Path(value="public/{calendarId}")
    public Response getCalendar(@PathParam(value="calendarId") String calendarId) {
        Calendar calendar = Calendar.getById((String)calendarId);
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)calendar);
        return this.export(calendar, true);
    }

    @HEAD
    @Path(value="private/{token}")
    public Response privateExportHead(@PathParam(value="token") String token) {
        Calendar calendar = this.getCalendarByToken(token);
        return this.exportHeadOnly(calendar, false);
    }

    @GET
    @Path(value="private/{token}")
    public Response privateExport(@PathParam(value="token") String token) {
        Calendar calendar = this.getCalendarByToken(token);
        return this.export(calendar, false);
    }

    private Calendar getCalendarByToken(String token) {
        PersistentResourceToken calendarToken = PersistentResourceToken.getToken((String)token);
        CalendarReference calendarRef = (CalendarReference)calendarToken.getResource(CalendarReference.class);
        if (calendarRef == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Calendar calendar = calendarRef.getEntity();
        CalendarWebManager.assertEntityIsDefined((IdentifiableEntity)calendar);
        return calendar;
    }

    private Response export(Calendar calendar, boolean hidePrivateData) {
        Response.ResponseBuilder response = Response.ok(output -> this.write(calendar, hidePrivateData, output));
        return this.applyCommonHeaders(response, calendar).build();
    }

    private Response exportHeadOnly(Calendar calendar, boolean hidePrivateData) {
        Response response;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.write(calendar, hidePrivateData, output);
            response = this.applyCommonHeaders(Response.ok(), calendar).header("Content-Length", (Object)output.size()).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        output.close();
        return response;
    }

    private Response.ResponseBuilder applyCommonHeaders(Response.ResponseBuilder response, Calendar calendar) {
        String name = calendar.getTitle() + ".ics";
        response.encoding(Charsets.UTF_8.name());
        response.header("Cache-Control", (Object)"no-store");
        response.header("Pragma", (Object)"no-cache");
        response.header("Expires", (Object)-1);
        response.header("Content-Type", (Object)"text/calendar");
        response.header("Content-Disposition", (Object)String.format("inline;filename=\"%s\"", name));
        return response;
    }

    private void write(Calendar calendar, boolean hidePrivateData, OutputStream output) {
        try {
            ExportDescriptor descriptor = (ExportDescriptor)ExportDescriptor.withOutputStream((OutputStream)output).withParameter("calendar", (Serializable)calendar).withParameter("hidePrivateData", (Serializable)Boolean.valueOf(hidePrivateData));
            this.getCalendarWebManager().exportCalendarAsICalendarFormat(calendar, descriptor);
        }
        catch (ExportException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public String getComponentId() {
        return null;
    }

    private CalendarWebManager getCalendarWebManager() {
        return CalendarWebManager.get(null);
    }
}

