/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.calendar;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Base64;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProvider;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProviderByInstance;

@Bean
@Singleton
public final class CalendarResourceURIs {
    static final String CALENDAR_EVENT_URI_PART = "events";
    static final String CALENDAR_EVENT_ATTENDEE_URI_PART = "attendees";
    static final String CALENDAR_EVENT_OCCURRENCE_URI_PART = "occurrences";
    static final String CALENDAR_BASE_URI = "calendar";
    @Inject
    private ComponentInstanceRoutingMapProviderByInstance routingMapProvider;

    public static CalendarResourceURIs get() {
        return (CalendarResourceURIs)ServiceProvider.getService(CalendarResourceURIs.class, (Annotation[])new Annotation[0]);
    }

    public URI ofCalendar(Calendar calendar) {
        if (calendar == null || !calendar.isPersisted()) {
            return null;
        }
        return this.getCalendarUriBuilder(calendar).build(new Object[0]);
    }

    URI ofICalPrivate(Calendar calendar) {
        if (calendar == null || !calendar.isPersisted()) {
            return null;
        }
        return this.getICalUriBuilder(calendar).path("private").path(calendar.getToken()).build(new Object[0]);
    }

    URI ofICalPublic(Calendar calendar) {
        if (calendar == null || !calendar.isPersisted()) {
            return null;
        }
        return this.getICalUriBuilder(calendar).path("public").path(calendar.getId()).build(new Object[0]);
    }

    URI ofEvent(CalendarEvent event) {
        if (event == null) {
            return null;
        }
        return this.getEventUriBuilder(event).build(new Object[0]);
    }

    public URI ofOccurrence(CalendarEventOccurrence occurrence) {
        if (occurrence == null) {
            return null;
        }
        return this.getOccurrenceUriBuilder(occurrence).build(new Object[0]);
    }

    URI ofEventPermalink(CalendarEventOccurrence occurrence) {
        if (occurrence == null) {
            return null;
        }
        return URI.create(occurrence.getCalendarEvent().getPermalink());
    }

    public URI ofOccurrencePermalink(CalendarEventOccurrence occurrence) {
        if (occurrence == null) {
            return null;
        }
        return URI.create(occurrence.getPermalink());
    }

    public URI ofOccurrenceView(CalendarEventOccurrence occurrence) {
        if (occurrence == null) {
            return null;
        }
        String instanceId = occurrence.getCalendarEvent().getCalendar().getComponentInstanceId();
        return this.getRoutingMap(instanceId).relativeToSilverpeas().getViewPage(occurrence.getIdentifier());
    }

    URI ofOccurrenceEdition(CalendarEventOccurrence occurrence) {
        if (occurrence == null) {
            return null;
        }
        String instanceId = occurrence.getCalendarEvent().getCalendar().getComponentInstanceId();
        return this.getRoutingMap(instanceId).relativeToSilverpeas().getEditionPage(occurrence.getIdentifier());
    }

    URI ofOccurrenceAttendee(CalendarEventOccurrence occurrence, Attendee attendee) {
        if (attendee == null) {
            return null;
        }
        return this.getOccurrenceUriBuilder(occurrence).path(CALENDAR_EVENT_ATTENDEE_URI_PART).path(attendee.getId()).build(new Object[0]);
    }

    private UriBuilder getICalUriBuilder(Calendar calendar) {
        String calendarComponentInstanceId = calendar.getComponentInstanceId();
        return this.getRoutingMap(calendarComponentInstanceId).absolute().getWebResourceUriBuilder().path("ical");
    }

    private UriBuilder getCalendarUriBuilder(Calendar calendar) {
        String calendarComponentInstanceId = calendar.getComponentInstanceId();
        return this.getRoutingMap(calendarComponentInstanceId).relativeToSilverpeas().getWebResourceUriBuilder().path(calendarComponentInstanceId).path(calendar.getId());
    }

    private UriBuilder getEventUriBuilder(CalendarEvent event) {
        return this.getCalendarUriBuilder(event.getCalendar()).path(CALENDAR_EVENT_URI_PART).path(event.getId());
    }

    private UriBuilder getOccurrenceUriBuilder(CalendarEventOccurrence occurrence) {
        return this.getEventUriBuilder(occurrence.getCalendarEvent()).path(CALENDAR_EVENT_OCCURRENCE_URI_PART).path(Base64.getEncoder().encodeToString(occurrence.getId().getBytes()));
    }

    private ComponentInstanceRoutingMapProvider getRoutingMap(String componentInstanceId) {
        return this.routingMapProvider.getByInstanceId(componentInstanceId);
    }
}

