/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.ContributionOperationContextPropertyHandler;
import org.silverpeas.core.contribution.attachment.ActifyDocumentProcessor;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.HistorisedDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.UnlockContext;
import org.silverpeas.core.contribution.attachment.model.UnlockOption;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.media.MetaData;
import org.silverpeas.core.io.media.MetadataExtractor;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.web.attachment.SimpleDocumentUploadData;
import org.silverpeas.core.web.http.RequestFile;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.web.util.IFrameAjaxTransportUtil;
import org.silverpeas.core.webapi.attachment.AbstractSimpleDocumentResource;
import org.silverpeas.core.webapi.attachment.SimpleDocumentEntity;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="documents/{componentId}/document/create")
@Authorized
public class SimpleDocumentResourceCreator
extends AbstractSimpleDocumentResource {
    @POST
    @Path(value="{filename}")
    @Consumes(value={"multipart/form-data"})
    public Response createDocument(@PathParam(value="filename") String filename) throws IOException {
        SimpleDocumentUploadData uploadData = SimpleDocumentUploadData.decode(this.getHttpRequest());
        try {
            String normalizedFileName = StringUtil.normalize((String)URLDecoder.decode(filename, Charsets.UTF_8));
            SimpleDocumentEntity entity = this.createSimpleDocument(uploadData, normalizedFileName);
            if ("IFrame".equals(uploadData.getXRequestedWith())) {
                return Response.ok().type(MediaType.TEXT_HTML_TYPE).entity((Object)IFrameAjaxTransportUtil.packObjectToJSonDataWithHtmlContainer(entity)).build();
            }
            return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)entity).build();
        }
        catch (WebApplicationException wae) {
            if ("IFrame".equals(uploadData.getXRequestedWith()) && wae.getResponse().getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                throw IFrameAjaxTransportUtil.createWebApplicationExceptionWithJSonErrorInHtmlContainer(wae);
            }
            throw wae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleDocumentEntity createSimpleDocument(SimpleDocumentUploadData uploadData, String filename) throws IOException {
        Context context = this.initializeContext(uploadData, filename);
        if (!context.contentDataAvailable()) {
            throw new WebApplicationException("Missing content data (file content or physical filename)", Response.Status.BAD_REQUEST);
        }
        try {
            SimpleAttachment attachment;
            SimpleDocument document;
            ContributionOperationContextPropertyHandler.parseRequest((HttpServletRequest)this.getHttpRequest());
            String lang = I18NHelper.checkLanguage((String)uploadData.getLanguage());
            String title = StringUtil.defaultStringIfNotDefined((String)uploadData.getTitle());
            String description = StringUtil.defaultStringIfNotDefined((String)uploadData.getDescription());
            if (!context.isDocumentTemplateContent() && AttachmentSettings.isUseFileMetadataForAttachmentDataEnabled() && !StringUtil.isDefined((String)title)) {
                MetadataExtractor extractor = MetadataExtractor.get();
                MetaData metadata = extractor.extractMetadata(context.getContentFile());
                title = StringUtil.defaultStringIfNotDefined((String)metadata.getTitle(), (String)title);
                if (!StringUtil.isDefined((String)description)) {
                    description = StringUtil.defaultStringIfNotDefined((String)metadata.getSubject(), (String)description);
                }
            }
            DocumentType attachmentContext = Optional.ofNullable(uploadData.getContext()).filter(StringUtil::isDefined).map(DocumentType::valueOf).orElse(DocumentType.attachment);
            SimpleDocumentPK pk = new SimpleDocumentPK(null, this.getComponentId());
            String userId = this.getUser().getId();
            boolean needCreation = true;
            boolean publicDocument = true;
            if (uploadData.getVersionType() != null) {
                document = AttachmentServiceProvider.getAttachmentService().findExistingDocument(pk, context.getFilename(), new ResourceReference(uploadData.getForeignId(), this.getComponentId()), lang);
                publicDocument = uploadData.getVersionType() == 0;
                boolean bl = needCreation = document == null;
                if (needCreation) {
                    attachment = SimpleAttachment.builder((String)lang).setFilename(context.getFilename()).setTitle(title).setDescription(description).setSize(context.getContentSize()).setContentType(context.getContentType()).setCreationData(userId, new Date()).build();
                    document = new HistorisedDocument(pk, uploadData.getForeignId(), 0, userId, attachment);
                    document.setDocumentType(attachmentContext);
                }
                document.setPublicDocument(publicDocument);
                document.setComment(uploadData.getComment());
            } else {
                attachment = SimpleAttachment.builder((String)lang).setFilename(context.getFilename()).setTitle(title).setDescription(description).setSize(context.getContentSize()).setContentType(context.getContentType()).setCreationData(userId, new Date()).build();
                document = new SimpleDocument(pk, uploadData.getForeignId(), 0, false, null, attachment);
                document.setDocumentType(attachmentContext);
            }
            document.setLanguage(lang);
            document.setTitle(title);
            document.setDescription(description);
            document.setSize(context.getContentFile().length());
            document = this.saveContent(context, document, needCreation, publicDocument, lang);
            ActifyDocumentProcessor.getProcessor().process(document);
            URI attachmentUri = this.getUri().getRequestUriBuilder().path("document").path(document.getLanguage()).build(new Object[0]);
            SimpleDocumentEntity simpleDocumentEntity = SimpleDocumentEntity.fromAttachment(document).withURI(attachmentUri);
            return simpleDocumentEntity;
        }
        catch (RuntimeException re) {
            this.performRuntimeException(re);
        }
        finally {
            context.ifContentDataAvailable(c -> FileUtils.deleteQuietly((File)c.getContentFile()));
        }
        throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
    }

    private SimpleDocument saveContent(Context context, SimpleDocument document, boolean needCreation, boolean publicDocument, String lang) throws IOException {
        SimpleDocument result;
        String userId = this.getUser().getId();
        try (BufferedInputStream content = new BufferedInputStream(new FileInputStream(context.getContentFile()));){
            if (needCreation) {
                result = AttachmentServiceProvider.getAttachmentService().createAttachment(document, (InputStream)content, context.mustIndex(), publicDocument);
            } else {
                document.edit(userId);
                AttachmentServiceProvider.getAttachmentService().lock(document.getId(), userId, lang);
                AttachmentServiceProvider.getAttachmentService().updateAttachment(document, (InputStream)content, context.mustIndex(), true);
                UnlockContext unlockContext = new UnlockContext(document.getId(), userId, lang);
                unlockContext.addOption(UnlockOption.UPLOAD);
                if (!publicDocument) {
                    unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
                }
                AttachmentServiceProvider.getAttachmentService().unlock(unlockContext);
                result = document;
            }
        }
        return result;
    }

    private Context initializeContext(SimpleDocumentUploadData uploadData, String filename) {
        Context context;
        try {
            context = new Context(this, uploadData, filename);
        }
        catch (RuntimeException re) {
            this.performRuntimeException(re);
            throw re;
        }
        return context;
    }

    public static class Context {
        private final AbstractSimpleDocumentResource resource;
        private final SimpleDocumentUploadData uploadedData;
        private final DocumentTemplate documentTemplate;
        private final RequestFile requestFile;
        private final String filename;
        private final File tempFile;

        public Context(AbstractSimpleDocumentResource resource, SimpleDocumentUploadData uploadedData, String filename) {
            this.resource = resource;
            this.uploadedData = uploadedData;
            this.documentTemplate = uploadedData.getDocumentTemplate().orElse(null);
            this.requestFile = this.documentTemplate == null && StringUtil.isDefined((String)uploadedData.getRequestFile().getName()) ? uploadedData.getRequestFile() : null;
            this.filename = this.computeFileName(filename);
            this.tempFile = this.createTemporaryFile();
        }

        boolean isDocumentTemplateContent() {
            return this.uploadedData.getDocumentTemplate().isPresent();
        }

        boolean contentDataAvailable() {
            return this.tempFile != null;
        }

        void ifContentDataAvailable(Consumer<Context> consumer) {
            if (this.contentDataAvailable()) {
                consumer.accept(this);
            }
        }

        public String getFilename() {
            Objects.requireNonNull(this.filename);
            return this.filename;
        }

        File getContentFile() {
            Objects.requireNonNull(this.tempFile);
            return this.tempFile;
        }

        long getContentSize() {
            Objects.requireNonNull(this.tempFile);
            return this.documentTemplate != null ? this.tempFile.length() : this.requestFile.getSize();
        }

        String getContentType() {
            Objects.requireNonNull(this.tempFile);
            return FileUtil.getMimeType((String)this.tempFile.getPath());
        }

        boolean mustIndex() {
            return this.uploadedData.getIndexIt();
        }

        private File createTemporaryFile() {
            if (StringUtil.isDefined((String)this.filename) && (this.documentTemplate != null || this.requestFile != null)) {
                File file;
                block9: {
                    InputStream uploadedInputStream = this.documentTemplate != null ? this.documentTemplate.openInputStream() : this.requestFile.getInputStream();
                    try {
                        File result = File.createTempFile("silverpeas_", this.filename);
                        FileUtils.copyToFile((InputStream)uploadedInputStream, (File)result);
                        this.resource.checkUploadedFile(result);
                        file = result;
                        if (uploadedInputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (uploadedInputStream != null) {
                                try {
                                    uploadedInputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new WebApplicationException((Throwable)e, Response.Status.PRECONDITION_FAILED);
                        }
                    }
                    uploadedInputStream.close();
                }
                return file;
            }
            return null;
        }

        private String computeFileName(String filename) {
            String result = this.documentTemplate != null ? (String)Optional.ofNullable(FilenameUtils.getBaseName((String)filename)).filter(StringUtil::isDefined).map(b -> b + "." + this.documentTemplate.getExtension()).orElse(null) : (StringUtil.isNotDefined((String)filename) && this.requestFile != null ? this.requestFile.getName() : filename);
            return result;
        }
    }
}

