/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.security.AccessControlContext;
import org.silverpeas.core.sharing.services.SharingServiceProvider;
import org.silverpeas.core.util.ZipUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.webapi.attachment.AbstractAttachmentResource;
import org.silverpeas.core.webapi.attachment.ZipEntity;

@WebService
@Path(value="sharing/attachments/{componentId}/{token}")
public class SharedAttachmentResource
extends AbstractAttachmentResource {
    static final String PATH = "sharing/attachments";
    @PathParam(value="token")
    private String token;

    protected String getResourceBasePath() {
        return PATH;
    }

    @GET
    @Path(value="{id}/{name}")
    @Produces(value={"application/octet-stream"})
    public Response getFileContent(@PathParam(value="id") String attachmentId) {
        return this.getAttachmentContent(attachmentId);
    }

    @GET
    @Path(value="{ids}/zip")
    @Produces(value={"application/json"})
    public ZipEntity zipFiles(@PathParam(value="ids") String attachmentIds) {
        StringTokenizer tokenizer = new StringTokenizer(attachmentIds, ",");
        File folderToZip = FileUtils.getFile((String[])new String[]{FileRepositoryManager.getTemporaryPath(), UUID.randomUUID().toString()});
        while (tokenizer.hasMoreTokens()) {
            SimpleDocument attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(tokenizer.nextToken()), null).getLastPublicVersion();
            if (!this.isFileReadable(attachment)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            try {
                FileOutputStream out = FileUtils.openOutputStream((File)FileUtils.getFile((File)folderToZip, (String[])new String[]{attachment.getFilename()}));
                try {
                    AttachmentServiceProvider.getAttachmentService().getBinaryContent((OutputStream)out, attachment.getPk(), null);
                }
                finally {
                    if (out == null) continue;
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        try {
            File zipFile = FileUtils.getFile((String[])new String[]{folderToZip.getPath() + ".zip"});
            URI downloadUri = this.getUri().getWebResourcePathBuilder().path(this.getToken()).path("zipcontent").path(zipFile.getName()).build(new Object[0]);
            long size = ZipUtil.compressPathToZip((File)folderToZip, (File)zipFile);
            ZipEntity zipEntity = new ZipEntity(this.getUri().getRequestUri(), downloadUri.toString(), size);
            return zipEntity;
        }
        catch (IOException | IllegalArgumentException | UriBuilderException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            FileUtils.deleteQuietly((File)folderToZip);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="zipcontent/{name}")
    @Produces(value={"application/octet-stream"})
    public Response getZipContent(@PathParam(value="name") String zipFileName) {
        this.checkFileName(zipFileName);
        String zipFilePath = FileRepositoryManager.getTemporaryPath() + zipFileName;
        File realFile = new File(zipFilePath);
        if (!Files.exists(realFile.toPath(), new LinkOption[0]) && !Files.isRegularFile(realFile.toPath(), new LinkOption[0])) {
            return Response.ok().build();
        }
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            Response response;
            try (FileInputStream in = new FileInputStream(realFile);){
                output.write((InputStream)in);
                response = Response.ok().entity((Object)output.toByteArray()).type("application/zip").build();
            }
            return response;
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    protected boolean isFileReadable(SimpleDocument attachment) {
        Ticket ticket = SharingServiceProvider.getSharingTicketService().getTicket(this.getToken());
        AccessControlContext ctx = AccessControlContext.about((SimpleDocument)attachment);
        return ticket != null && ticket.getAccessControl().isReadable(ctx);
    }

    protected String getToken() {
        return this.token;
    }

    private void checkFileName(String fileName) {
        try {
            FileUtil.checkFileName((String)fileName);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }
}

