/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.tools;

import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

public abstract class AbstractTool {
    private final String language;
    private final LookHelper lookHelper;
    private final String visibleKey;
    private final String id;
    private final String labelKey;
    private final String urlComponentName;
    private final String urlSuffix;

    protected AbstractTool(String language, LookHelper lookHelper, String visibleKey, String id, String labelKey, String urlComponentName) {
        this(language, lookHelper, visibleKey, id, labelKey, urlComponentName, "Main");
    }

    protected AbstractTool(String language, LookHelper lookHelper, String visibleKey, String id, String labelKey, String urlComponentName, String urlSuffix) {
        this.language = language;
        this.lookHelper = lookHelper;
        this.visibleKey = visibleKey;
        this.id = id;
        this.labelKey = labelKey;
        this.urlComponentName = urlComponentName;
        this.urlSuffix = urlSuffix;
    }

    protected LocalizationBundle getMessages() {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.homePage.multilang.homePageBundle", (String)this.language);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.getMessages().getString(this.labelKey);
    }

    public String getUrl() {
        return URLUtil.getURL((String)this.urlComponentName, null, (String)"") + this.urlSuffix;
    }

    public int getNb() {
        return 0;
    }

    public boolean isVisible() {
        return this.getLookHelper().getSettings(this.visibleKey, true);
    }

    protected LookHelper getLookHelper() {
        return this.lookHelper;
    }
}

