/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.result;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.pdc.pdc.model.GlobalSilverResult;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.personalization.service.PersonalizationServiceProvider;
import org.silverpeas.core.util.MultiSilverpeasBundle;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.web.search.ResultDisplayer;
import org.silverpeas.core.web.search.ResultDisplayerProvider;
import org.silverpeas.core.web.search.ResultSearchRendererUtil;
import org.silverpeas.core.web.search.SearchResultContentVO;
import org.silverpeas.core.web.util.viewgenerator.html.ImageTag;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class HtmlSearchResultTag
extends TagSupport {
    private static final long serialVersionUID = -7747695403360864218L;
    private static final String PDC_BUNDLE_PREFIX_KEY = "result.template.";
    protected static final String RESULT_TEMPLATE_ALL = "ALL";
    protected static final String RESULT_TEMPLATE_NONE = "NONE";
    private String userId = null;
    private GlobalSilverResult gsr = null;
    private Integer sortValue = null;
    private boolean exportEnabled = false;
    private MultiSilverpeasBundle resources = null;
    private Map<String, Boolean> componentSettings = new HashMap<String, Boolean>();

    public int doStartTag() throws JspException {
        try {
            this.pageContext.getOut().print(this.getHtmlResult());
        }
        catch (IOException ex) {
            throw new JspException("Silverpeas Java to html paragraph Converter Tag", (Throwable)ex);
        }
        return 6;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GlobalSilverResult getGsr() {
        return this.gsr;
    }

    public void setGsr(GlobalSilverResult gsr) {
        this.gsr = gsr;
    }

    public Integer getSortValue() {
        return this.sortValue;
    }

    public void setSortValue(Integer sortValue) {
        this.sortValue = sortValue;
    }

    public boolean getExportEnabled() {
        return this.exportEnabled;
    }

    public void setExportEnabled(boolean exportEnabled) {
        this.exportEnabled = exportEnabled;
    }

    private String getHtmlResult() {
        ResultDisplayer resultDisplayer;
        boolean processResultTemplating;
        ComponentInstLight component;
        String instanceId;
        MultiSilverpeasBundle settings = this.getResources();
        String componentName = instanceId = this.gsr.getInstanceId();
        String addedInformation = null;
        if (StringUtil.isDefined((String)instanceId) && !instanceId.startsWith("user") && !instanceId.startsWith("pdc") && (component = OrganizationControllerProvider.getOrganisationController().getComponentInstLight(instanceId)) != null && (processResultTemplating = this.isResultTemplating(instanceId, componentName = component.getName())) && (resultDisplayer = ResultDisplayerProvider.getResultDisplayer(componentName)) != null) {
            addedInformation = resultDisplayer.getResultContent(new SearchResultContentVO(this.userId, this.gsr, this.sortValue, this.exportEnabled, settings));
        }
        return this.generateHTMLSearchResult(settings, componentName, addedInformation);
    }

    private boolean isResultTemplating(String instanceId, String componentName) {
        boolean doResultTemplating = false;
        Boolean cacheResult = this.componentSettings.get(componentName);
        if (cacheResult != null) {
            return cacheResult;
        }
        String compConfig = PDC_BUNDLE_PREFIX_KEY + componentName;
        String listComponent = this.getResources().getSetting(compConfig, "");
        if (StringUtil.isDefined((String)listComponent)) {
            for (String curInstanceId : listComponent.split(",")) {
                if (!curInstanceId.equals(instanceId) && !RESULT_TEMPLATE_ALL.equals(curInstanceId)) continue;
                this.componentSettings.put(instanceId, Boolean.TRUE);
                return true;
            }
        }
        this.componentSettings.put(instanceId, Boolean.FALSE);
        return doResultTemplating;
    }

    private String generateHTMLSearchResult(MultiSilverpeasBundle resources, String componentName, String extraInformation) {
        String sCreationDate;
        StringBuilder result = new StringBuilder();
        String downloadSrc = "<img src=\"" + resources.getIcon("pdcPeas.download") + "\" class=\"fileDownload\" alt=\"" + resources.getString("pdcPeas.DownloadInfo") + "\" title=\"" + resources.getString("pdcPeas.DownloadInfo") + "\"/>";
        String language = this.getResources().getLanguage();
        Object sName = WebEncodeHelper.javaStringToHtmlString((String)this.gsr.getName(language));
        String sDescription = StringUtil.abbreviate((String)this.gsr.getDescription(language), (int)400);
        String sURL = this.gsr.getTitleLink();
        String sDownloadURL = this.gsr.getDownloadLink();
        String sLocation = this.gsr.getLocation();
        String sCreatorName = this.gsr.getCreatorName();
        String id = this.gsr.isLinked() ? this.gsr.getLinkedResourceId() : this.gsr.getId();
        try {
            sCreationDate = this.sortValue == 4 ? resources.getOutputDate(this.gsr.getCreationDate()) : resources.getOutputDate(this.gsr.getLastUpdateDate());
        }
        catch (Exception e) {
            sCreationDate = null;
        }
        String serverName = this.gsr.getServerName();
        result.append("<li class=\"lineResult ").append(this.gsr.getSpaceId()).append(" ");
        result.append(componentName).append(" ");
        result.append(this.gsr.getInstanceId()).append(" ");
        String indexType = this.gsr.getType();
        result.append(indexType).append(" ");
        if (this.gsr.isNew()) {
            result.append("new-contribution ");
        }
        result.append(serverName).append("\">");
        if (this.exportEnabled && this.gsr.isExportable() && this.gsr.isUserAllowedToDownloadFile()) {
            String checked = "";
            if (this.gsr.isSelected()) {
                checked = "checked=\"checked\"";
            }
            result.append("<input class=\"selection\" type=\"checkbox\" ").append(checked).append(" name=\"resultObjects\" value=\"").append(id).append("-").append(this.gsr.getInstanceId()).append("\"/>");
        }
        if (resources.getSetting("PertinenceVisible", false)) {
            result.append("<div class=\"pertinence\">").append(ResultSearchRendererUtil.displayPertinence(this.gsr.getScore())).append("</div>");
        }
        result.append("<div class=\"content\">");
        if (StringUtil.isDefined((String)this.gsr.getThumbnailURL())) {
            result.append("<div class=\"thumb\">");
            if ("UserFull".equals(indexType)) {
                result.append("<img class=\"avatar\" src=\"").append(URLUtil.getApplicationURL()).append(this.gsr.getThumbnailURL()).append("\" border=\"0\" />");
            } else {
                ImageTag image = new ImageTag();
                image.setSrc(this.gsr.getThumbnailURL());
                image.setSize("60x");
                result.append(image.toString());
            }
            result.append("</div>");
        }
        if (indexType != null) {
            sName = this.adjustResultName(resources, (String)sName, indexType);
            if (indexType.startsWith("Attachment") || indexType.startsWith("Versioning") || indexType.equals("LinkedFile")) {
                String fileType = FilenameUtils.getExtension((String)this.gsr.getAttachmentFilename());
                String fileIcon = FileRepositoryManager.getFileIcon((String)fileType);
                if (!StringUtil.isDefined((String)sName)) {
                    sName = this.gsr.getAttachmentFilename();
                }
                sName = "<img src=\"" + fileIcon + "\" class=\"fileIcon\"/>" + (String)sName;
            } else if (indexType.equals("Comment")) {
                String commentIcon = URLUtil.getApplicationURL() + "/util/icons/talk2user.gif";
                sName = "<img src=\"" + commentIcon + "\" class=\"fileIcon\"/>" + (String)sName;
            }
        }
        result.append("<div class=\"locationTitle\">");
        String curResultId = "readSpanId_" + this.gsr.getResultId();
        Object cssClass = "";
        String cssClassDisableVisited = "";
        if (this.gsr.isHasRead()) {
            cssClass = "markedAsRead";
            cssClassDisableVisited = "markedAsReadDisableVisited";
        }
        if (!this.gsr.isUserAllowedToDownloadFile()) {
            cssClass = (String)cssClass + " forbidden-download";
        }
        if (this.gsr.isUserAllowedToDownloadFile()) {
            result.append("<a href=\"").append(sURL).append("\" class=\"").append(cssClassDisableVisited).append("\">");
        }
        result.append("<span id=\"").append(curResultId).append("\" class=\"").append((String)cssClass).append("\">").append((String)sName).append("</span>");
        if (this.gsr.isUserAllowedToDownloadFile()) {
            result.append("</a>");
        }
        if (this.gsr.isAlias()) {
            result.append(" (").append(resources.getString("GML.alias")).append(")");
        }
        if (StringUtil.isDefined((String)sDownloadURL) && this.gsr.isUserAllowedToDownloadFile()) {
            result.append("<a href=\"").append(sDownloadURL).append("\" class=\"fileDownload\" target=\"_blank\">").append(downloadSrc).append("</a>");
        }
        if (this.gsr.isPreviewable()) {
            result.append(" <img onclick=\"previewFile(this, '").append(this.gsr.getAttachmentId()).append("',").append(this.gsr.isVersioned()).append(")\" class=\"preview-file\" src=\"").append(resources.getIcon("pdcPeas.file.preview")).append("\" alt=\"").append(resources.getString("GML.preview.file")).append("\" title=\"").append(resources.getString("GML.preview.file")).append("\"/>");
        }
        if (this.gsr.isViewable()) {
            result.append(" <img onclick=\"viewFile(this, '").append(this.gsr.getAttachmentId()).append("',").append(this.gsr.isVersioned()).append(")\" class=\"view-file\" src=\"").append(resources.getIcon("pdcPeas.file.view")).append("\" alt=\"").append(resources.getString("GML.view.file")).append("\" title=\"").append(resources.getString("GML.view.file")).append("\"/>");
        }
        if (!this.gsr.isDownloadAllowedForReaders()) {
            String forbiddenDownloadHelp = "";
            forbiddenDownloadHelp = this.gsr.isUserAllowedToDownloadFile() ? resources.getString("GML.download.forbidden.readers") : resources.getString("GML.download.forbidden");
            result.append(" <img class=\"forbidden-download-file\" src=\"").append(resources.getIcon("pdcPeas.file.forbidden-download")).append("\" alt=\"").append(forbiddenDownloadHelp).append("\" title=\"").append(forbiddenDownloadHelp).append("\"/>");
        }
        result.append("</div>");
        if (StringUtil.isDefined((String)sDescription)) {
            result.append("<div class=\"description\">").append(WebEncodeHelper.javaStringToHtmlParagraphe((String)sDescription)).append("</div>");
        }
        if (StringUtil.isDefined((String)extraInformation)) {
            result.append("<div class=\"extra\">");
            result.append(extraInformation);
            result.append("</div>");
        }
        if (this.sortValue == 7 && this.gsr.getHits() >= 0) {
            result.append("<div class=\"popularity\">").append(resources.getStringWithParams("pdcPeas.popularity", Integer.toString(this.gsr.getHits()))).append(" | </div>");
        }
        if (StringUtil.isDefined((String)sCreationDate)) {
            result.append("<div class=\"creationDate\"> ").append(sCreationDate).append(" | </div>");
        }
        if (StringUtil.isDefined((String)sCreatorName)) {
            result.append("<div class=\"creatorName\">").append(WebEncodeHelper.javaStringToHtmlString((String)sCreatorName)).append(" | </div>");
        }
        if (this.getResources().getSetting("external.search.enable", false) && StringUtil.isDefined((String)serverName)) {
            result.append("<div class=\"serveurName\"> ").append(serverName).append(" | </div>");
        }
        if (StringUtil.isDefined((String)sLocation)) {
            result.append("<div class=\"location\">").append(WebEncodeHelper.javaStringToHtmlString((String)sLocation)).append("</div>");
        }
        result.append("</div>");
        result.append("</li>");
        return result.toString();
    }

    private UserPreferences getUserPreferences() {
        return PersonalizationServiceProvider.getPersonalizationService().getUserSettings(this.getUserId());
    }

    private MultiSilverpeasBundle getResources() {
        if (this.resources == null) {
            String language = this.getUserPreferences().getLanguage();
            this.resources = new MultiSilverpeasBundle(ResourceLocator.getLocalizationBundle((String)"org.silverpeas.pdcPeas.multilang.pdcBundle", (String)language), ResourceLocator.getSettingBundle((String)"org.silverpeas.pdcPeas.settings.pdcPeasIcons"), ResourceLocator.getSettingBundle((String)"org.silverpeas.pdcPeas.settings.pdcPeasSettings"), language);
        }
        return this.resources;
    }

    public void setResources(MultiSilverpeasBundle resources) {
        this.resources = resources;
    }

    private String adjustResultName(MultiSilverpeasBundle bundle, String name, String indexType) {
        String adjustedName = name;
        if (StringUtil.isNotDefined((String)name)) {
            int idx = indexType.indexOf(95);
            String type = idx > 0 ? indexType.substring(0, idx) : indexType;
            try {
                adjustedName = bundle.getString(String.format("result.type.%s.label.default", type));
            }
            catch (MissingResourceException e) {
                SilverLogger.getLogger((Object)((Object)this)).silent((Throwable)e);
            }
        }
        return adjustedName;
    }
}

