/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.pagination;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.Pagination;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractPagination
implements Pagination {
    private int nbItems = -1;
    private int nbItemsPerPage = -1;
    private int firstItemIndex = -1;
    private String actionSuffix = "";
    private String altPreviousPage = "";
    private String altNextPage = "";
    private String baseURL = null;
    private int nbPageThreshold = -1;
    private int nbPagesOnLeft = -1;
    private int nbPagesOnRight = -1;
    private LocalizationBundle multilang;

    protected AbstractPagination() {
    }

    static PaginationPage getPaginationPageFrom(String pageSizeAsString, String itemIndexAsString, PaginationPage currentPagination) {
        PaginationPage pagination = currentPagination != null ? currentPagination : PaginationPage.DEFAULT;
        int pageNumber = pagination.getPageNumber();
        int pageSize = pagination.getPageSize();
        if (StringUtil.isInteger((String)pageSizeAsString)) {
            pageSize = Integer.parseInt(pageSizeAsString);
        }
        if (StringUtil.isInteger((String)itemIndexAsString)) {
            pageNumber = Integer.parseInt(itemIndexAsString) / pageSize + 1;
        }
        return new PaginationPage(pageNumber, pageSize);
    }

    @Override
    public void init(int nbItems, int nbItemsPerPage, int firstItemIndex) {
        this.nbItems = nbItems;
        this.nbItemsPerPage = nbItemsPerPage;
        this.firstItemIndex = firstItemIndex > nbItems - 1 ? (nbItems == 0 ? 0 : firstItemIndex - nbItemsPerPage) : firstItemIndex;
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    @Override
    public int getNbItems() {
        return this.nbItems;
    }

    public int getNbItemsPerPage() {
        return this.nbItemsPerPage;
    }

    @Override
    public int getFirstItemIndex() {
        return this.firstItemIndex;
    }

    @Override
    public int getLastItemIndex() {
        int end = this.getFirstItemIndex() + this.getNbItemsPerPage();
        if (end > this.getNbItems() - 1) {
            end = this.getNbItems();
        }
        return end;
    }

    public int getCurrentPage() {
        int nbItemsByPage = this.getNbItemsPerPage();
        int currentPage = 1;
        if (nbItemsByPage > 0) {
            currentPage = this.getFirstItemIndex() / nbItemsByPage + 1;
        }
        return currentPage;
    }

    public int getNbPage() {
        int nbItemsByPage = this.getNbItemsPerPage();
        int nbPage = nbItemsByPage > 0 ? (this.getNbItems() - 1) / nbItemsByPage + 1 : 1;
        return Math.max(nbPage, 1);
    }

    @Override
    public boolean isLastPage() {
        return this.getFirstItemIndex() + 1 + this.getNbItemsPerPage() > this.getNbItems();
    }

    @Override
    public int getIndexForPreviousPage() {
        return this.getIndexForDirectPage(this.getCurrentPage() - 1);
    }

    @Override
    public int getIndexForDirectPage(int page) {
        int result = (page - 1) * this.getNbItemsPerPage();
        if (result > this.getNbItems()) {
            result = this.getIndexForLastPage();
        }
        return result;
    }

    @Override
    public int getIndexForCurrentPage() {
        return this.getIndexForDirectPage(this.getCurrentPage());
    }

    @Override
    public int getIndexForNextPage() {
        return this.getIndexForDirectPage(this.getCurrentPage() + 1);
    }

    public int getIndexForLastPage() {
        return this.getNbPage() * this.getNbItemsPerPage() - this.getNbItemsPerPage();
    }

    public String getActionSuffix() {
        return this.actionSuffix;
    }

    @Override
    public void setActionSuffix(String actionSuffix) {
        this.actionSuffix = actionSuffix;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public void setBaseURL(String url) {
        this.baseURL = url;
    }

    public String getAltPreviousPage() {
        return this.altPreviousPage;
    }

    @Override
    public void setAltPreviousPage(String text) {
        this.altPreviousPage = text;
    }

    public String getAltNextPage() {
        return this.altNextPage;
    }

    @Override
    public void setAltNextPage(String text) {
        this.altNextPage = text;
    }

    protected int getNumberPageThreshold() {
        if (this.nbPageThreshold == -1) {
            this.nbPageThreshold = Integer.parseInt(GraphicElementFactory.getSettings().getString("Pagination.NbPageThreshold", "6"));
            this.nbPagesOnRight = this.nbPageThreshold / 2;
        }
        return this.nbPageThreshold;
    }

    protected int getNumberPageOnCurrentLeft(int currentPage) {
        int offset;
        if (this.nbPagesOnLeft == -1) {
            int threshold = this.getNumberPageThreshold();
            this.nbPagesOnLeft = threshold / 2;
            this.nbPagesOnLeft = threshold % 2 == 0 ? this.nbPagesOnLeft - 1 : this.nbPagesOnLeft;
        }
        offset = (offset = this.getNbPage() - currentPage) < this.nbPagesOnRight ? this.nbPagesOnRight - offset : 0;
        return this.nbPagesOnLeft + offset;
    }

    protected int getNumberPageOnCurrentRight(int currentPage) {
        if (this.nbPagesOnRight == -1) {
            this.nbPagesOnRight = this.getNumberPageThreshold() / 2;
        }
        int offset = currentPage <= this.nbPagesOnLeft ? Math.abs(currentPage - this.nbPagesOnLeft - 1) : 0;
        return this.nbPagesOnRight + offset;
    }

    protected boolean displayTotalNumberOfPages() {
        return GraphicElementFactory.getSettings().getBoolean("Pagination.DisplayTotalNumberOfPages", false);
    }

    protected List<Integer> getNbItemPerPageList() {
        int nbItemPerPage;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 1;
        while ((nbItemPerPage = GraphicElementFactory.getSettings().getInteger("Pagination.NbItemPerPage." + i, 0)) > 0) {
            result.add(nbItemPerPage);
            ++i;
        }
        return result;
    }

    protected int getIndexThreshold() {
        int value = GraphicElementFactory.getSettings().getInteger("Pagination.IndexThreshold");
        return this.defaultValueIfNotDefined(value);
    }

    protected int getNumberPerPageThreshold() {
        int value = GraphicElementFactory.getSettings().getInteger("Pagination.NumberPerPageThreshold");
        return this.defaultValueIfNotDefined(value);
    }

    protected int getJumperThreshold() {
        int value = GraphicElementFactory.getSettings().getInteger("Pagination.JumperThreshold");
        return this.defaultValueIfNotDefined(value);
    }

    protected int getPaginationAllThreshold() {
        int value = GraphicElementFactory.getSettings().getInteger("Pagination.PaginationAllThreshold");
        return this.defaultValueIfNotDefined(value);
    }

    private int defaultValueIfNotDefined(int value) {
        if (value <= 0) {
            return Integer.MAX_VALUE;
        }
        return value;
    }

    public LocalizationBundle getMultilang() {
        return this.multilang;
    }

    @Override
    public void setMultilang(LocalizationBundle multilang) {
        this.multilang = multilang;
    }

    protected String getString(String key) {
        return this.getMultilang().getString(key);
    }

    protected String getStringWithParam(String key, String ... params) {
        return this.getMultilang().getStringWithParams(key, (Object[])params);
    }

    public String getString(String key, String defaultValue) {
        String translation;
        try {
            translation = this.getMultilang().getString(key);
        }
        catch (MissingResourceException ex) {
            SilverLogger.getLogger((Object)this).debug(ex.getMessage(), new Object[]{ex});
            translation = defaultValue;
        }
        return translation;
    }
}

