/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.formpanes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormButtonSubmit;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormLabel;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormLine;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormPane;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormPaneWA;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormTextField;

public class FormTextArea
extends FormLine {
    private int cols;
    private int rows;
    private int nbCharMax;

    public FormTextArea() {
        this.setName("newFormTextArea");
        this.setLabel("newFormTextArea");
        this.rows = 4;
        this.cols = 20;
        this.nbCharMax = 255;
        this.setType("textarea");
        this.setDBEntry(true);
    }

    public FormTextArea(String nam, String val) {
        super(nam, val);
        this.setLabel(nam);
        this.rows = 4;
        this.cols = 20;
        this.nbCharMax = 255;
        this.setType("textarea");
        this.setDBEntry(true);
    }

    public FormTextArea(String nam, String val, String lab) {
        super(nam, val);
        this.setLabel(lab);
        this.rows = 4;
        this.cols = 20;
        this.nbCharMax = 255;
        this.setType("textarea");
        this.setDBEntry(true);
    }

    public FormTextArea(String nam, String val, String lab, int nbcols, int nbrows) {
        super(nam, val);
        this.setLabel(lab);
        this.rows = nbrows;
        this.cols = nbcols;
        this.nbCharMax = 255;
        this.setType("textarea");
        this.setDBEntry(true);
    }

    public void setCols(int nbcols) {
        this.cols = nbcols;
    }

    public void setRows(int nbrows) {
        this.rows = nbrows;
    }

    public void setNbCharMax(int nb) {
        this.nbCharMax = nb;
    }

    public void setCols(String nbcols) {
        if (nbcols != null) {
            try {
                this.cols = Integer.parseInt(nbcols);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setRows(String nbrows) {
        if (nbrows != null) {
            try {
                this.rows = Integer.parseInt(nbrows);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String print() {
        String retour = "\n<td class=\"couleurFondCadre\" align=\"right\" width=\"50%\"><span class=\"txtnote\">" + this.noNull(this.label);
        retour = retour + "&nbsp;</span></td>";
        retour = retour + "<td class=\"couleurFondCadre\" width=\"50%\">&nbsp;";
        retour = retour + "<font size=1><textarea name=\"" + this.name + "\" rows=\"" + this.rows + "\" cols=\"" + this.cols + "\" wrap=virtual>";
        retour = retour + this.noNull(this.value) + "\n</textarea></font></td>";
        return retour;
    }

    @Override
    public FormPane getDescriptor(String nam, String url, PageContext pc) {
        FormPaneWA fpw = new FormPaneWA(nam, url, pc);
        fpw.add(new FormLabel("configuratorTitle", this.message.getString("TextAreaConfig"), ""));
        fpw.add(new FormTextField("configuratorLabelValue", "", this.message.getString("EnterLabelValue") + " : "));
        fpw.add(new FormTextField("configuratorNbCols", "20", this.message.getString("NbCols") + " : "));
        fpw.add(new FormTextField("configuratorNbRows", "4", this.message.getString("NbRows") + " : "));
        fpw.add(new FormTextArea("configuratorDefaultValue", "", this.message.getString("EnterDefaultValue") + " : "));
        fpw.add(new FormButtonSubmit("newConfiguratorSubmitButton", this.message.getString("Create")));
        return fpw;
    }

    @Override
    public void getConfigurationByRequest(HttpServletRequest req) {
        this.setLabel(req.getParameter("configuratorLabelValue"));
        this.setCols(req.getParameter("configuratorNbCols"));
        this.setRows(req.getParameter("configuratorNbRows"));
        this.setValue(req.getParameter("configuratorDefaultValue"));
    }

    @Override
    public String printDemo() {
        String retour = "\n<td class=\"couleurFondCadre\" align=\"right\" width=\"50%\"><span class=\"txtnote\">" + this.label;
        retour = retour + "&nbsp;</span></td>";
        retour = retour + "<td class=\"couleurFondCadre\" width=\"50%\">&nbsp;";
        retour = retour + "<font size=1><textarea name=\"" + this.name + "\" rows=\"" + this.rows + "\" cols=\"" + this.cols + "\" wrap=virtual>";
        retour = retour + this.value + "\n</textarea></font></td>";
        return retour;
    }

    @Override
    public String toXML() {
        String retour = "\n<field id=\"" + this.id + "\" type=\"textarea\">";
        retour = retour + "\n<name>" + this.name + "</name>";
        retour = retour + "\n<label>" + this.label + "</label>";
        retour = retour + "\n<value>" + this.value + "</value>";
        retour = retour + "\n<rows>" + String.valueOf(this.rows) + "</rows>";
        retour = retour + "\n<cols>" + String.valueOf(this.cols) + "</cols>";
        retour = retour + "\n<size>" + String.valueOf(this.nbCharMax) + "</size>";
        retour = retour + "\n<dbtype>" + this.DBType + "</dbtype>";
        retour = retour + "\n</field>";
        return retour;
    }

    @Override
    public String getDBColumnCreationRequest() {
        String result = this.id + " " + this.DBType;
        if (this.DBType.equals("character varying")) {
            result = result + "(" + String.valueOf(this.nbCharMax) + ")";
        }
        result = this.mandatory ? result + " NOT NULL, " : result + " , ";
        return result;
    }
}

