/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.browsebars;

import java.util.ArrayList;
import java.util.List;
import org.owasp.encoder.Encode;
import org.silverpeas.core.i18n.I18NBean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBar;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBarElement;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractBrowseBar
implements BrowseBar {
    private String domainName = null;
    private String componentName = null;
    private String componentLink = null;
    private String information = null;
    private String path = null;
    private I18NBean i18nBean = null;
    private String language = null;
    private String url = null;
    private List<String> languages = null;
    private String spaceId = null;
    private String componentId = null;
    private MainSessionController mainSessionController = null;
    private final List<BrowseBarElement> elements = new ArrayList<BrowseBarElement>();
    private String spaceJavascriptCallback = null;
    private String componentJavascriptCallback = null;
    private boolean clickable = true;
    private boolean ignoreComponentLink = true;
    protected LookHelper look = null;

    public AbstractBrowseBar() {
    }

    public AbstractBrowseBar(String domainName, String componentName, String information, String path) {
        this.domainName = domainName;
        this.componentName = componentName;
        this.information = information;
        this.path = path;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public void setComponentName(String componentName) {
        this.componentName = componentName;
        this.componentLink = null;
    }

    @Override
    public void setComponentName(String componentName, String link2) {
        this.componentName = componentName;
        this.componentLink = link2;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentLink() {
        return this.componentLink;
    }

    @Override
    public void setExtraInformation(String information) {
        this.information = information;
        if (StringUtil.isDefined((String)information) && (information.contains("<") || information.contains(">"))) {
            this.information = Encode.forHtml((String)information);
        }
    }

    public String getExtraInformation() {
        return this.information;
    }

    @Override
    public void setPath(String path) {
        if (StringUtil.isDefined((String)path)) {
            this.path = path;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    public I18NBean getI18NBean() {
        return this.i18nBean;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getUrl() {
        return this.url;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    public void addElement(BrowseBarElement element) {
        this.elements.add(element);
    }

    @Override
    public void addElements(List<BrowseBarElement> elements) {
        this.elements.addAll(elements);
    }

    @Override
    public void setElements(List<BrowseBarElement> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
    }

    public List<BrowseBarElement> getElements() {
        return this.elements;
    }

    @Override
    public void setI18N(I18NBean bean, String language) {
        this.i18nBean = bean;
        this.language = language;
    }

    @Override
    public void setI18N(String url, String language) {
        this.url = url;
        this.language = language;
    }

    @Override
    public void setI18N(List<String> languages, String language) {
        this.languages = languages;
        this.language = language;
    }

    public boolean isI18N() {
        return I18NHelper.isI18nContentActivated && (this.getI18NBean() != null || this.getUrl() != null || this.getLanguages() != null);
    }

    public String getI18NHTMLLinks() {
        if (this.getI18NBean() != null) {
            return I18NHelper.getHTMLLinks((I18NBean)this.getI18NBean(), (String)this.getLanguage());
        }
        if (this.getUrl() != null) {
            return I18NHelper.getHTMLLinks((String)this.getUrl(), (String)this.getLanguage());
        }
        return I18NHelper.getHTMLLinks(this.getLanguages(), (String)this.getLanguage());
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public MainSessionController getMainSessionController() {
        return this.mainSessionController;
    }

    @Override
    public void setMainSessionController(MainSessionController mainSessionController) {
        this.mainSessionController = mainSessionController;
    }

    @Override
    public void setSpaceJavascriptCallback(String callback) {
        this.spaceJavascriptCallback = callback;
    }

    @Override
    public void setComponentJavascriptCallback(String callback) {
        this.componentJavascriptCallback = callback;
    }

    public String getSpaceJavascriptCallback() {
        return this.spaceJavascriptCallback;
    }

    public String getComponentJavascriptCallback() {
        return this.componentJavascriptCallback;
    }

    @Override
    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    @Override
    public void setIgnoreComponentLink(boolean ignore) {
        this.ignoreComponentLink = ignore;
    }

    boolean ignoreComponentLink() {
        return this.ignoreComponentLink;
    }

    @Override
    public void setLook(LookHelper look) {
        this.look = look;
    }
}

