/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes.pagination;

import java.util.Vector;

public class WADataPaginatorHeader {
    public static final int FLAGS_SORTABLE = 1;
    public static final int FLAGS_ASCENDING = 2;
    public static final int FLAGS_SORT_KEY = 4;
    Vector<FieldDescriptor> m_Fields = new Vector(10);
    String m_SortKey = null;
    int m_SortKeyIndex = -1;
    String m_RoutingAddress = null;

    public int getFieldCount() {
        return this.m_Fields.size();
    }

    public void addField(String field, String displayName, int flags, String routingAddress) {
        this.m_Fields.add(new FieldDescriptor(field, displayName, flags, routingAddress));
        if ((flags & 4) != 0) {
            this.m_SortKeyIndex = this.m_Fields.size() - 1;
            this.m_SortKey = field;
        }
    }

    public void toggleFieldSortOrder(int idx) {
        if (idx < 0 || idx >= this.m_Fields.size()) {
            return;
        }
        if (this.isFieldAscending(idx)) {
            this.setFieldDescending(idx);
        } else {
            this.setFieldAscending(idx);
        }
    }

    private void setFieldDescending(int idx) {
        FieldDescriptor fd = this.m_Fields.get(idx);
        int f = fd.getFlags();
        fd.setFlags(f &= 0xFFFFFFFD);
    }

    private void setFieldAscending(int idx) {
        FieldDescriptor fd = this.m_Fields.get(idx);
        int f = fd.getFlags();
        fd.setFlags(f |= 2);
    }

    public boolean isFieldSortable(int idx) {
        if (idx < 0 || idx >= this.m_Fields.size()) {
            return false;
        }
        return this.m_Fields.get(idx).isSortable();
    }

    public boolean isFieldAscending(int idx) {
        if (idx < 0 || idx >= this.m_Fields.size()) {
            return false;
        }
        return this.m_Fields.get(idx).isAscending();
    }

    public boolean isFieldDescending(int idx) {
        if (idx < 0 || idx >= this.m_Fields.size()) {
            return false;
        }
        return this.m_Fields.get(idx).isDescending();
    }

    public String getFieldRoutingAddress(int idx) {
        if (idx < 0 || idx >= this.m_Fields.size()) {
            return null;
        }
        return this.m_Fields.get(idx).getRoutingAddress();
    }

    public String getSortKey() {
        return this.m_SortKey;
    }

    public int getSortKeyIndex() {
        return this.m_SortKeyIndex;
    }

    public String getFieldDisplayName(int idx) {
        if (idx < 0 || idx >= this.m_Fields.size()) {
            return null;
        }
        return this.m_Fields.get(idx).getDisplayName();
    }

    public String getFieldName(int idx) {
        if (idx < 0 || idx >= this.m_Fields.size()) {
            return null;
        }
        return this.m_Fields.get(idx).getName();
    }

    class FieldDescriptor {
        String m_Name = null;
        String m_DisplayName = null;
        int m_Flags;
        String m_RoutingAddress = null;

        FieldDescriptor(String name, String dn, int flags, String routingAddress) {
            this.m_Name = name;
            this.m_DisplayName = dn;
            this.m_Flags = flags;
            this.m_RoutingAddress = routingAddress;
        }

        public void setRoutingAddress(String address) {
            this.m_RoutingAddress = address;
        }

        public String getRoutingAddress() {
            return this.m_RoutingAddress;
        }

        public void setFlags(int value) {
            this.m_Flags = value;
        }

        public String getName() {
            return this.m_Name;
        }

        public String getDisplayName() {
            return this.m_DisplayName;
        }

        public int getFlags() {
            return this.m_Flags;
        }

        public boolean isSortable() {
            return (this.m_Flags & 1) != 0;
        }

        public boolean isAscending() {
            if (this.isSortable()) {
                return (this.m_Flags & 2) != 0;
            }
            return false;
        }

        public boolean isDescending() {
            if (this.isSortable()) {
                return (this.m_Flags & 2) == 0;
            }
            return false;
        }
    }
}

