/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.Collections;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.AbstractArrayPane;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.Pagination;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.util.StringUtil;

public class ArrayPaneSilverpeasV5
extends AbstractArrayPane {
    private String printPseudoColumn() {
        return "<td><img src=\"" + GraphicElementFactory.getIconsPath() + "/1px.gif\" width=\"2\" height=\"2\" alt=\"\"/></td>";
    }

    @Override
    public String print() {
        GraphicElementFactory gef = (GraphicElementFactory)this.getSession().getAttribute("SessionGraphicElementFactory");
        Pagination pagination = this.getPagination(this.getNbItems());
        String sep = "&";
        String baseUrl = this.getUrl();
        StringBuilder url = new StringBuilder(baseUrl);
        if (baseUrl.indexOf(63) < 0) {
            url.append("?");
        } else {
            url.append(sep);
        }
        url.append("ArrayPaneAction").append("=ChangePage").append(sep).append("ArrayPaneTarget").append("=").append(this.getName()).append(sep).append("PaginationPaneIndex").append("=");
        pagination.setBaseURL(url.toString());
        int columnsCount = this.getColumns().size();
        if (!this.isPaginationOptimized() && !this.getLines().isEmpty() && this.getColumnToSort() != 0 && this.getColumnToSort() <= columnsCount) {
            Collections.sort(this.getLines());
        }
        if (this.getCellSpacing() == 0) {
            columnsCount = columnsCount * 2 + 1;
        }
        StringBuilder result = new StringBuilder();
        result.append("<div class=\"arrayPane\">\n").append("<table width=\"100%\" cellspacing=\"");
        result.append(this.getCellSpacing()).append("\" cellpadding=\"").append(this.getCellPadding()).append("\"");
        result.append(" id=\"").append(this.getName()).append("\" class=\"tableArrayPane\"");
        result.append(" summary=\"").append(this.getSummary()).append("\">");
        if (this.getTitle() != null) {
            result.append("<caption>").append(this.getTitle()).append("</caption>");
        }
        if (this.getCellSpacing() == 0) {
            result.append("<tr>");
            result.append("<td colspan=\"").append(columnsCount).append("\">");
            result.append("<img src=\"").append(this.getIconsPath()).append("/1px.gif\" width=\"1\" height=\"1\" alt=\"\"/>");
            result.append("</td>");
            result.append("</tr>\n");
        }
        result.append("<thead>\n");
        result.append("<tr>\n");
        if (this.getCellSpacing() == 0) {
            result.append(this.printPseudoColumn());
        }
        for (ArrayColumn column : this.getColumns()) {
            result.append(column.print());
            if (this.getCellSpacing() != 0) continue;
            result.append(this.printPseudoColumn());
        }
        result.append("</tr>\n").append("</thead>\n").append("<tbody>\n");
        this.appendArrayPaneLines(result, pagination);
        result.append("</tbody>\n");
        this.appendPaginationAndExport(result, columnsCount, pagination, gef);
        result.append("</table>\n");
        result.append("</div>\n");
        if (this.isMovableLines()) {
            result.append(this.printSortJavascriptFunction());
        }
        return result.toString();
    }

    private void appendArrayPaneLines(StringBuilder result, Pagination pagination) {
        boolean ajaxExport = StringUtil.getBooleanValue((String)this.getRequest().getParameter("ArrayPaneAjaxExport"));
        if (this.getLines().isEmpty() || ajaxExport) {
            result.append("<tr><td>&nbsp;</td></tr>\n");
        } else {
            this.appendArrayPaneLinesToRender(result, pagination);
        }
    }

    private void appendArrayPaneLinesToRender(StringBuilder result, Pagination pagination) {
        if (this.getState().getMaximumVisibleLine() == -1) {
            for (ArrayLine curLine : this.getLines()) {
                this.printArrayPaneLine(result, curLine);
            }
        } else {
            this.getState().setFirstVisibleLine(pagination.getIndexForCurrentPage());
            if (this.isPaginationOptimized()) {
                this.getLines().forEach(l -> this.printArrayPaneLine(result, (ArrayLine)l));
            } else {
                Pair<Integer, Integer> indexes = pagination.getStartLastIndexes();
                int firstIndex = (Integer)indexes.getLeft();
                int lastIndex = (Integer)indexes.getRight();
                for (int i = firstIndex; i < lastIndex; ++i) {
                    this.printArrayPaneLine(result, this.getLines().get(i));
                }
            }
        }
    }

    private void appendPaginationAndExport(StringBuilder result, int columnsCount, Pagination pagination, GraphicElementFactory gef) {
        boolean paginationVisible;
        boolean bl = paginationVisible = -1 != this.getState().getMaximumVisibleLine();
        if (paginationVisible || this.isExportData()) {
            result.append("<tfoot class=\"footerNav\">");
            result.append("<td colspan=\"").append(columnsCount).append("\">\n");
            if (paginationVisible) {
                result.append(pagination.printIndex(""));
            }
            if (this.isExportData()) {
                result.append("<div class=\"exportlinks\">");
                result.append("<a href=\"").append(this.getExportUrl()).append("\"><span class=\"export csv\">");
                result.append(gef.getMultilang().getString("GEF.export.option.csv")).append("</span></a>");
                result.append("</div>");
                SimpleCache cache = CacheAccessorProvider.getSessionCacheAccessor().getCache();
                cache.put((Object)"Silverpeas_arraypane_columns", this.getColumns());
                cache.put((Object)"Silverpeas_arraypane_lines", this.getLines());
                result.append("</div>");
            }
            result.append("</td>\n");
            result.append("</tfoot>");
        }
    }

    private void printArrayPaneLine(StringBuilder result, ArrayLine curLine) {
        if (this.getCellSpacing() == 0) {
            result.append(curLine.printWithPseudoColumns());
        } else {
            result.append(curLine.print());
        }
    }
}

