/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.subscription.bean;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBeanService;
import org.silverpeas.core.web.subscription.bean.SubscriptionBeanService;

public class SubscriptionBeanProvider {
    private static final String DEFAULT_IMPLEMENTATION_ID = "default";
    private static final Map<String, SubscriptionBeanService> typeImplementations = new HashMap<String, SubscriptionBeanService>();

    private SubscriptionBeanProvider() {
    }

    public static void registerSubscriptionBeanService(AbstractSubscriptionBeanService service) {
        List<SubscriptionResourceType> types = service.getHandledSubscriptionResourceTypes();
        if (types.isEmpty()) {
            typeImplementations.put(DEFAULT_IMPLEMENTATION_ID, service);
        } else {
            types.forEach(t -> typeImplementations.put(t.getName(), service));
        }
    }

    public static String getSubscriptionTypeListLabel(SubscriptionResourceType type, String language) {
        return SubscriptionBeanProvider.getService(type).getSubscriptionTypeListLabel(type, language);
    }

    public static List<AbstractSubscriptionBean> getByUserSubscriberAndSubscriptionResourceType(SubscriptionResourceType type, String userId, String language) {
        Collection list = SubscriptionServiceProvider.getSubscribeService().getByUserSubscriber(userId).stream().filter(s -> s.getResource().getType() == type).collect(Collectors.toList());
        return SubscriptionBeanProvider.getService(type).toSubscriptionBean(list, language);
    }

    public static Optional<AbstractSubscriptionBean> getBySubscription(Subscription subscription, String language) {
        List<Subscription> list = Collections.singletonList(subscription);
        return SubscriptionBeanProvider.getService(subscription.getResource().getType()).toSubscriptionBean(list, language).stream().findFirst();
    }

    private static SubscriptionBeanService getService(SubscriptionResourceType type) {
        return Optional.ofNullable(typeImplementations.get(type.getName())).orElse(typeImplementations.get(DEFAULT_IMPLEMENTATION_ID));
    }
}

