/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.sharing.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.EmailAddress;
import org.silverpeas.core.web.sharing.bean.SharingNotificationVO;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class FileSharingUserNotification
extends AbstractTemplateUserNotificationBuilder<Ticket> {
    private static final String FILE_SHARING_BUNDLE_SUBJECT_KEY = "sharing.notification.message.subject.file";
    private static final String FOLDER_SHARING_BUNDLE_SUBJECT_KEY = "sharing.notification.message.subject.folder";
    private static final String PUBLICATION_SHARING_BUNDLE_SUBJECT_KEY = "sharing.notification.message.subject.publication";
    private static final String FILE_SHARING_TEMPLATE_PATH = "fileSharing";
    private static final String FILE_SHARING_TEMPLATE_FILE_NAME = "fileSharing";
    private static final String NODE_SHARING_TEMPLATE_FILE_NAME = "nodeSharing";
    private static final String PUBLI_SHARING_TEMPLATE_FILE_NAME = "publiSharing";
    private static final String COMMA_CHARACTER = ",";
    private final SharingNotificationVO fileSharingParam;

    public FileSharingUserNotification(Ticket resource, SharingNotificationVO fileSharingParam) {
        super((Object)resource);
        this.fileSharingParam = fileSharingParam;
    }

    protected String getBundleSubjectKey() {
        String sharedObjectType = ((Ticket)this.getResource()).getSharedObjectType();
        if ("Node".equals(sharedObjectType)) {
            return FOLDER_SHARING_BUNDLE_SUBJECT_KEY;
        }
        if ("Publication".equals(sharedObjectType)) {
            return PUBLICATION_SHARING_BUNDLE_SUBJECT_KEY;
        }
        return FILE_SHARING_BUNDLE_SUBJECT_KEY;
    }

    protected void performTemplateData(String language, Ticket resource, SilverpeasTemplate template) {
        Ticket ticket = (Ticket)this.getResource();
        String userId = this.getUserId();
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("senderUser", (Object)OrganizationControllerProvider.getOrganisationController().getUserDetail(userId));
        if (StringUtil.isDefined((String)this.fileSharingParam.getAdditionalMessage())) {
            template.setAttribute("additionalMessage", (Object)Encode.forHtml((String)this.fileSharingParam.getAdditionalMessage()));
        }
        template.setAttribute("ticket", (Object)resource);
        if (ticket.getNbAccessMax() != 0) {
            template.setAttribute("limitedAccess", (Object)"true");
        }
    }

    private String getUserId() {
        String userId = ((Ticket)this.getResource()).getLastModifier();
        if (!StringUtil.isDefined((String)userId)) {
            userId = ((Ticket)this.getResource()).getCreatorId();
        }
        return userId;
    }

    protected void performNotificationResource(String language, Ticket resource, NotificationResourceData notificationResourceData) {
    }

    protected String getTemplatePath() {
        return "fileSharing";
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.sharing.multilang.fileSharingBundle";
    }

    protected String getTemplateFileName() {
        String sharedObjectType = ((Ticket)this.getResource()).getSharedObjectType();
        if ("Node".equals(sharedObjectType)) {
            return NODE_SHARING_TEMPLATE_FILE_NAME;
        }
        if ("Publication".equals(sharedObjectType)) {
            return PUBLI_SHARING_TEMPLATE_FILE_NAME;
        }
        return "fileSharing";
    }

    protected NotifAction getAction() {
        return NotifAction.UPDATE;
    }

    protected String getComponentInstanceId() {
        return null;
    }

    protected String getSender() {
        return this.getUserId();
    }

    protected Collection<String> getUserIdsToNotify() {
        String selectedUsersStr = this.fileSharingParam.getSelectedUsers();
        ArrayList<String> listUsers = new ArrayList<String>();
        if (StringUtil.isDefined((String)selectedUsersStr)) {
            Collections.addAll(listUsers, selectedUsersStr.split(COMMA_CHARACTER));
        }
        return listUsers;
    }

    protected Collection<String> getExternalAddressesToNotify() {
        ArrayList<String> externalAddresses = new ArrayList<String>();
        String externalAddressesStr = this.fileSharingParam.getExternalEmails();
        if (StringUtil.isDefined((String)externalAddressesStr)) {
            String[] externalAddressesArray;
            externalAddressesStr = externalAddressesStr.replaceAll(" ", COMMA_CHARACTER).replaceAll(";", COMMA_CHARACTER);
            for (String externalAddress : externalAddressesArray = externalAddressesStr.split(COMMA_CHARACTER)) {
                if (!EmailAddress.isValid((String)(externalAddress = externalAddress.trim()))) continue;
                externalAddresses.add(externalAddress);
            }
        }
        return externalAddresses;
    }

    public static void notify(Ticket resource, SharingNotificationVO fileSharingParam) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new FileSharingUserNotification(resource, fileSharingParam));
        }
        catch (Exception e) {
            SilverLogger.getLogger(FileSharingUserNotification.class).error((Throwable)e);
        }
    }

    protected String getResourceURL(Ticket resource) {
        return this.fileSharingParam.getAttachmentUrl();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        if (NODE_SHARING_TEMPLATE_FILE_NAME.equals(this.getTemplateFileName())) {
            return "sharing.notification.notifFolderLinkLabel";
        }
        if (PUBLI_SHARING_TEMPLATE_FILE_NAME.equals(this.getTemplateFileName())) {
            return "sharing.notification.notifPublicationLinkLabel";
        }
        return "sharing.notification.notifFileLinkLabel";
    }
}

