/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.web.http.FileResponse;
import org.silverpeas.core.webapi.media.EmbedMediaPlayerDispatcher;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractFileSender
extends HttpServlet {
    protected void sendFile(HttpServletRequest request, HttpServletResponse response, SilverpeasFile file) throws IOException {
        if (file != null && file.exists()) {
            try {
                if (!EmbedMediaPlayerDispatcher.from(request, response).dispatchWithSilverpeasFile(file)) {
                    FileResponse.fromServlet(request, response).sendSilverpeasFile(file);
                    response.getOutputStream().flush();
                }
            }
            catch (IOException e) {
                SilverLogger.getLogger((Object)((Object)this)).error("file: " + file.getAbsolutePath(), (Throwable)e);
                this.displayWarningHtmlCode(response);
            }
        } else {
            response.setHeader("Content-Length", "0");
            response.setStatus(404);
            response.getOutputStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayWarningHtmlCode(HttpServletResponse res) throws IOException {
        ServletOutputStream out = res.getOutputStream();
        StringReader sr = new StringReader(this.getSettingBunde().getString("warning"));
        try {
            IOUtils.copy((Reader)sr, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)((Object)this)).error("warning properties", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)sr);
        }
    }

    protected abstract SettingBundle getSettingBunde();
}

