/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.look;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
public class SilverpeasLook {
    public static final String DEFAULT_WALLPAPER_PROPERTY = "wallPaper";
    public static final String SPACE_CSS = "styles";
    private static final String REVERSED_SPACE_PATH_CACHE_PREFIX = SilverpeasLook.class.getSimpleName() + "@REVERSED_SPACE_PATH@SPACEID@";
    @Inject
    private OrganizationController organizationController;

    public static SilverpeasLook getSilverpeasLook() {
        return (SilverpeasLook)ServiceProvider.getService(SilverpeasLook.class, (Annotation[])new Annotation[0]);
    }

    public boolean hasSpaceWallpaper(String spaceId) {
        return StringUtil.isDefined((String)this.getWallPaperURL(spaceId));
    }

    @Nullable
    public String getWallpaperOfSpace(String spaceId) {
        return this.getCachedSpaceReversedPath(spaceId).stream().map(s -> this.getWallPaperURL(s.getId())).filter(StringUtil::isDefined).findFirst().orElse(null);
    }

    public String getWallpaperOfSpaceOrDefaultOne(String spaceId) {
        GraphicElementFactory elementFactory;
        Object wallpaperURL = this.getWallpaperOfSpace(spaceId);
        if (!StringUtil.isDefined((String)wallpaperURL) && !StringUtil.isDefined((String)(wallpaperURL = (elementFactory = new GraphicElementFactory("Initial")).getIcon(DEFAULT_WALLPAPER_PROPERTY)))) {
            wallpaperURL = FileServerUtils.getApplicationContext() + "/admin/jsp/icons/silverpeasV5/bandeauTop.jpg";
        }
        return wallpaperURL;
    }

    private String getWallPaperURL(String spaceId) {
        String id = this.getShortSpaceId(spaceId);
        String basePath = this.getSpaceBasePath(id);
        File dir = new File(basePath);
        if (dir.exists() && dir.isDirectory()) {
            Collection wallpapers = FileUtils.listFiles((File)dir, (IOFileFilter)FileFilterUtils.prefixFileFilter((String)DEFAULT_WALLPAPER_PROPERTY, (IOCase)IOCase.INSENSITIVE), null);
            for (File wallpaper : wallpapers) {
                if (!wallpaper.isFile() || !FileUtil.isImage((String)wallpaper.getName())) continue;
                return this.getURLOfElement(id, wallpaper.getName());
            }
        }
        return null;
    }

    public String getSpaceWithCSS(String spaceId) {
        return this.getCachedSpaceReversedPath(spaceId).stream().filter(s -> StringUtil.isDefined((String)this.getSpaceCSSURL(s.getId()))).map(s -> this.getShortSpaceId(s.getId())).findFirst().orElse(null);
    }

    public String getCSSOfSpace(String spaceId) {
        return this.getCachedSpaceReversedPath(spaceId).stream().map(s -> this.getSpaceCSSURL(s.getId())).filter(StringUtil::isDefined).findFirst().orElse(null);
    }

    private List<SpaceInstLight> getCachedSpaceReversedPath(String spaceId) {
        List spacePath = (List)CacheAccessorProvider.getThreadCacheAccessor().getCache().computeIfAbsent((Object)(REVERSED_SPACE_PATH_CACHE_PREFIX + spaceId), List.class, () -> {
            List path = this.organizationController.getPathToSpace(spaceId);
            Collections.reverse(path);
            return path;
        });
        return Objects.requireNonNull(spacePath);
    }

    public String getCSSOfSpaceLook(String spaceId) {
        return Optional.ofNullable(this.getSpaceLook(spaceId)).map(GraphicElementFactory::getCSSOfLook).orElse(null);
    }

    public String getSpaceLook(String spaceId) {
        List<SpaceInstLight> path = this.getCachedSpaceReversedPath(spaceId);
        return path.stream().map(SpaceInstLight::getLook).filter(StringUtil::isDefined).findFirst().orElse(null);
    }

    private String getSpaceCSSURL(String spaceId) {
        String filename;
        File css;
        String id = this.getShortSpaceId(spaceId);
        File dir = new File(this.getSpaceBasePath(id));
        if (dir.exists() && dir.isDirectory() && (css = new File(dir, filename = "styles.css")).exists()) {
            return this.getURLOfElement(id, filename);
        }
        return null;
    }

    public String getSpaceBasePath(String spaceId) {
        return FileRepositoryManager.getAbsolutePath((String)("Space" + spaceId), (String[])new String[]{"look"});
    }

    private String getURLOfElement(String spaceId, String filename) {
        return FileServerUtils.getOnlineURL((String)("Space" + spaceId), (String)filename, (String)filename, (String)FileUtil.getMimeType((String)filename), (String)"look");
    }

    private String getShortSpaceId(String spaceId) {
        if (spaceId.startsWith("WA")) {
            return spaceId.substring(2);
        }
        return spaceId;
    }

    private SilverpeasLook() {
    }
}

