/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.index;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.cache.model.ExternalCache;
import org.silverpeas.kernel.logging.SilverLogger;

@Singleton
public class IndexationProcessExecutor {
    private static final String INDEXATION_PROCESS_EXECUTOR_KEY = "INDEXATION_PROCESS_EXECUTOR_KEY";

    private IndexationProcessExecutor() {
    }

    public static IndexationProcessExecutor get() {
        return (IndexationProcessExecutor)ServiceProvider.getService(IndexationProcessExecutor.class, (Annotation[])new Annotation[0]);
    }

    public boolean isCurrentExecution() {
        ExternalCache cache = CacheAccessorProvider.getApplicationCacheAccessor().getCache();
        Pair process = (Pair)cache.get((Object)INDEXATION_PROCESS_EXECUTOR_KEY, Pair.class);
        return process != null && !((Future)process.getRight()).isDone();
    }

    public void stopCurrentExecutionIfAny() {
        Future task;
        ExternalCache cache = CacheAccessorProvider.getApplicationCacheAccessor().getCache();
        Pair process = (Pair)cache.get((Object)INDEXATION_PROCESS_EXECUTOR_KEY, Pair.class);
        Future future = task = process != null ? (Future)process.getRight() : null;
        if (process != null && !task.isDone()) {
            try {
                task.cancel(true);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("stopping indexation process failed", (Throwable)e);
            }
        }
    }

    public void execute(IndexationProcess indexationProcess) {
        block3: {
            ExternalCache cache = CacheAccessorProvider.getApplicationCacheAccessor().getCache();
            try {
                if (this.isCurrentExecution()) {
                    SilverLogger.getLogger((Object)this).warn("an indexation processing is already running, how is it possible ? That is a huge treatment which one and only one should be running at a same time!!!", new Object[0]);
                    SilverLogger.getLogger((Object)this).warn("so the new indexation request has been ignored", new Object[0]);
                    return;
                }
                Future future = ManagedThreadPool.getPool().invoke((Callable)indexationProcess, ManagedThreadPool.ExecutionConfig.defaultConfig().withMaxThreadPoolSizeOf(1));
                cache.put((Object)INDEXATION_PROCESS_EXECUTOR_KEY, (Object)Pair.of((Object)indexationProcess, (Object)future), 0, 0);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("starting indexation process failed", (Throwable)e);
                if (!(e instanceof InterruptedException)) break block3;
                Thread.currentThread().interrupt();
            }
        }
    }

    public static abstract class IndexationProcess
    implements Callable<Void> {
        public abstract void perform();

        @Override
        public Void call() {
            String threadId = String.valueOf(Thread.currentThread().getId());
            try {
                SilverLogger.getLogger(IndexationProcessExecutor.class).info("starting indexation process on thread with id ''{0}'')", new Object[]{threadId});
                this.perform();
                SilverLogger.getLogger(IndexationProcessExecutor.class).info("ending indexation process on thread with id ''{0}'')", new Object[]{threadId});
            }
            catch (Exception e) {
                SilverLogger.getLogger(IndexationProcessExecutor.class).error("indexation process failure on thread with id ''{0}'')", new Object[]{threadId}, (Throwable)e);
            }
            return null;
        }
    }
}

