/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.http;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.web.http.FileResponse;
import org.silverpeas.kernel.util.StringUtil;

public class ServletFileResponse
extends FileResponse {
    private static final String CONTENT_LENGTH = "Content-Length";

    ServletFileResponse(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    public void sendSilverpeasFile(SilverpeasFile file) {
        if (StringUtil.isNotDefined((String)this.forcedMimeType)) {
            this.forceMimeType(file.getMimeType());
        }
        this.sendPath(Paths.get(file.toURI()));
    }

    void sendPath(Path path) {
        try {
            Path absoluteFilePath = path.toAbsolutePath();
            String fileName = this.getFileName(absoluteFilePath);
            String fileMimeType = this.getMimeType(absoluteFilePath);
            int fullContentLength = (int)Files.size(absoluteFilePath);
            Matcher partialMatcher = this.getPartialMatcher();
            boolean isPartialRequest = partialMatcher.matches();
            this.response.setContentType(fileMimeType);
            String filename = ServletFileResponse.encodeAttachmentFilenameAsUtf8(fileName);
            this.response.setHeader("Content-Disposition", filename);
            if (isPartialRequest) {
                FileResponse.ContentRangeData data = this.getContentRangeData(partialMatcher, fullContentLength);
                this.response.setHeader(CONTENT_LENGTH, String.format("%s", data.partContentLength));
                this.response.setHeader("Accept-Ranges", "bytes");
                this.response.setHeader("ETag", this.getFileIdentifier(path));
                this.response.setDateHeader("Last-Modified", this.getLastModifiedDate(path).getTime());
                this.response.setDateHeader("Expires", this.getExpirationDate().getTime());
                this.response.setHeader("Content-Range", data.headerValue);
                this.response.setStatus(206);
                this.partialOutputStream(absoluteFilePath, data, (OutputStream)this.response.getOutputStream());
            } else {
                this.response.setHeader(CONTENT_LENGTH, String.valueOf(fullContentLength));
                this.fullOutputStream(path, (OutputStream)this.response.getOutputStream());
            }
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public ServletFileResponse forceFileId(String fileId) {
        super.forceFileId(fileId);
        return this;
    }

    @Override
    public ServletFileResponse forceMimeType(String mimeType) {
        super.forceMimeType(mimeType);
        return this;
    }

    @Override
    public ServletFileResponse forceCharacterEncoding(String forcedCharacterEncoding) {
        super.forceCharacterEncoding(forcedCharacterEncoding);
        return this;
    }

    @Override
    public ServletFileResponse forceFileName(String fileName) {
        super.forceFileName(fileName);
        return this;
    }

    @Override
    public ServletFileResponse noCache() {
        super.noCache();
        return this;
    }
}

