/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.ddwe;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.wbe.WbeEdition;
import org.silverpeas.core.web.ddwe.DragAndDropMode;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBarElement;

public class DragAndDropEditorConfig {
    private static final String WBE_CONFIG_KEY = "WBE_CONFIG";
    private final String validateUrl;
    private final String cancelUrl;
    private final List<BrowseBarElement> manualBrowseBarElements = new ArrayList<BrowseBarElement>();
    private DragAndDropMode mode = DragAndDropMode.WEB;

    private DragAndDropEditorConfig(String validateUrl, String cancelUrl) {
        this.validateUrl = validateUrl;
        this.cancelUrl = cancelUrl;
    }

    public static Builder withConnectors(String validateUrl, String cancelUrl) {
        return new Builder(validateUrl, cancelUrl);
    }

    public static Optional<DragAndDropEditorConfig> getFrom(WbeEdition.Configuration wbeConfiguration) {
        return wbeConfiguration.get(WBE_CONFIG_KEY).filter(DragAndDropEditorConfig.class::isInstance).map(DragAndDropEditorConfig.class::cast);
    }

    public String getValidateUrl() {
        return this.validateUrl;
    }

    public String getCancelUrl() {
        return this.cancelUrl;
    }

    public List<BrowseBarElement> getManualBrowseBarElements() {
        return this.manualBrowseBarElements;
    }

    public DragAndDropMode getMode() {
        return this.mode;
    }

    public void applyTo(WbeEdition.Configuration wbeConfiguration) {
        wbeConfiguration.put(WBE_CONFIG_KEY, (Object)this);
    }

    public static class Builder {
        private final DragAndDropEditorConfig config;

        private Builder(String validateUrl, String cancelUrl) {
            this.config = new DragAndDropEditorConfig(validateUrl, cancelUrl);
        }

        public Builder addBrowseBarElement(BrowseBarElement element) {
            this.config.manualBrowseBarElements.add(element);
            return this;
        }

        public Builder setMailMode() {
            this.config.mode = DragAndDropMode.MAIL;
            return this;
        }

        public DragAndDropEditorConfig build() {
            return this.config;
        }
    }
}

