/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar.notification;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.notification.user.CalendarEventOccurrenceNotifyUserNotificationBuilder;
import org.silverpeas.core.notification.user.AbstractComponentInstanceManualUserNotification;
import org.silverpeas.core.notification.user.NotificationContext;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.webapi.calendar.CalendarEventOccurrenceEntity;

public abstract class AbstractCalendarInstanceManualUserNotification
extends AbstractComponentInstanceManualUserNotification {
    private static final String OCCURRENCE_KEY = "CalendarEventOccurrenceKey";

    protected boolean check(NotificationContext context) {
        String occurrenceId = context.getContributionId();
        CalendarEventOccurrence occurrence = this.getCalendarEventOccurrence(occurrenceId);
        context.put((Object)OCCURRENCE_KEY, (Object)occurrence);
        return occurrence.canBeAccessedBy(context.getSender());
    }

    public UserNotification createUserNotification(NotificationContext context) {
        CalendarEventOccurrence occurrence = (CalendarEventOccurrence)context.getObject((Object)OCCURRENCE_KEY);
        return new CalendarEventOccurrenceNotifyUserNotificationBuilder(occurrence, context.getSender()).build();
    }

    private CalendarEventOccurrence getCalendarEventOccurrence(String occurrenceId) {
        String decodeId = CalendarEventOccurrenceEntity.decodeId(occurrenceId);
        return (CalendarEventOccurrence)CalendarEventOccurrence.getById((String)decodeId).orElseThrow(() -> new WebApplicationException(SilverpeasExceptionMessages.unknown((String)"occurrence", (Object)decodeId), Response.Status.NOT_FOUND));
    }
}

