/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar.ical;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.silverpeas.core.util.Charsets;

public final class StringUtils {
    private StringUtils() {
    }

    public static byte[] encodeString(String string, Charset encoding) throws CharacterCodingException {
        return StringUtils.encodeArray(string.toCharArray(), encoding);
    }

    public static byte[] encodeString(String string, String encoding) throws CharacterCodingException {
        return StringUtils.encodeString(string, Charsets.toCharset((String)encoding));
    }

    static byte[] encodeArray(char[] chars, Charset encoding) throws CharacterCodingException {
        if (StandardCharsets.US_ASCII.equals(encoding)) {
            byte[] array = new byte[chars.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (byte)chars[i];
            }
            return array;
        }
        ByteBuffer buffer = encoding.newEncoder().encode(CharBuffer.wrap(chars));
        byte[] array = new byte[buffer.limit()];
        System.arraycopy(buffer.array(), 0, array, 0, array.length);
        return array;
    }

    public static String decodeToString(byte[] bytes, String encoding) {
        return new String(StringUtils.decodeToArray(bytes, Charsets.toCharset((String)encoding)));
    }

    public static String decodeToString(byte[] bytes, Charset encoding) {
        return new String(StringUtils.decodeToArray(bytes, encoding));
    }

    static char[] decodeToArray(byte[] bytes, Charset encoding) {
        if (StandardCharsets.US_ASCII.equals(encoding)) {
            char[] array = new char[bytes.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (char)bytes[i];
            }
            return array;
        }
        try {
            CharBuffer buffer = encoding.newDecoder().decode(ByteBuffer.wrap(bytes));
            char[] array = new char[buffer.limit()];
            System.arraycopy(buffer.array(), 0, array, 0, array.length);
            return array;
        }
        catch (Exception nioException) {
            return new String(bytes, encoding).toCharArray();
        }
    }

    public static String decodePassword(String encodedPassword) {
        StringBuilder buffer = new StringBuilder(encodedPassword.substring(3));
        return StringUtils.decodeBASE64(buffer.reverse().toString().replace('$', '=')).trim();
    }

    public static String decodeBASE64(String string) {
        return StringUtils.decodeToString(DatatypeConverter.parseBase64Binary((String)string), StandardCharsets.UTF_8);
    }

    public static String encodeBASE64(byte[] data) {
        return DatatypeConverter.printBase64Binary((byte[])data);
    }
}

