/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PermissionEntry
implements Comparable<PermissionEntry>,
PermissionConstants {
    final boolean isAllow;
    final PrivilegeBits privilegeBits;
    private final int index;
    private final String path;
    final RestrictionPattern restriction;

    PermissionEntry(@NotNull String path, boolean isAllow, int index, @NotNull PrivilegeBits privilegeBits, @NotNull RestrictionPattern restriction) {
        this.path = path;
        this.isAllow = isAllow;
        this.index = index;
        this.privilegeBits = privilegeBits;
        this.restriction = restriction;
    }

    boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        return this.restriction == RestrictionPattern.EMPTY || this.restriction.matches(tree, property);
    }

    boolean matches(@NotNull String treePath) {
        return this.restriction == RestrictionPattern.EMPTY || this.restriction.matches(treePath);
    }

    boolean matches(@NotNull String path, boolean isProperty) {
        return this.restriction == RestrictionPattern.EMPTY || this.restriction.matches(path, isProperty);
    }

    boolean matches() {
        return this.restriction == RestrictionPattern.EMPTY || this.restriction.matches();
    }

    boolean matchesParent(@NotNull String parentPath) {
        return Text.isDescendantOrEqual((String)this.path, (String)parentPath) && (this.restriction == RestrictionPattern.EMPTY || this.restriction.matches(parentPath, false));
    }

    @Override
    public int compareTo(@NotNull PermissionEntry pe) {
        int otherDepth;
        if (Objects.equals(this.path, pe.path)) {
            return Integer.compare(pe.index, this.index);
        }
        int depth = PathUtils.getDepth((String)this.path);
        if (depth == (otherDepth = PathUtils.getDepth((String)pe.path))) {
            return this.path.compareTo(pe.path);
        }
        return depth < otherDepth ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PermissionEntry) {
            PermissionEntry that = (PermissionEntry)o;
            return this.index == that.index && this.isAllow == that.isAllow && this.privilegeBits.equals((Object)that.privilegeBits) && this.path.equals(that.path) && this.restriction.equals(that.restriction);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.privilegeBits, this.index, this.path, this.isAllow, this.restriction);
    }
}

