/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.authentication.token.CommitMarker;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConstants;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenValidatorProvider
extends ValidatorProvider
implements TokenConstants {
    private static final Logger log = LoggerFactory.getLogger(TokenValidatorProvider.class);
    private final String userRootPath;
    private final TreeProvider treeProvider;

    TokenValidatorProvider(@NotNull ConfigurationParameters userConfig, @NotNull TreeProvider treeProvider) {
        this.userRootPath = (String)userConfig.getConfigValue("usersPath", (Object)"/rep:security/rep:authorizables/rep:users");
        this.treeProvider = treeProvider;
    }

    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo commitInfo) {
        return new TokenValidator(before, after, commitInfo);
    }

    @NotNull
    private static CommitFailedException constraintViolation(int code, @NotNull String message) {
        return new CommitFailedException("Constraint", code, message);
    }

    @NotNull
    private static Tree verifyNotNull(@Nullable Tree tree) {
        Validate.checkState((tree != null ? 1 : 0) != 0);
        return tree;
    }

    private final class TokenValidator
    extends DefaultValidator
    implements TokenConstants {
        private final Tree parentBefore;
        private final Tree parentAfter;
        private final CommitInfo commitInfo;

        TokenValidator(@NotNull NodeState parentBefore, @NotNull NodeState parentAfter, CommitInfo commitInfo) {
            this(tokenValidatorProvider.treeProvider.createReadOnlyTree(parentBefore), tokenValidatorProvider.treeProvider.createReadOnlyTree(parentAfter), commitInfo);
        }

        private TokenValidator(@NotNull Tree parentBefore, @NotNull Tree parentAfter, CommitInfo commitInfo) {
            this.parentBefore = parentBefore;
            this.parentAfter = parentAfter;
            this.commitInfo = commitInfo;
        }

        private TokenValidator(@NotNull Tree parentAfter, CommitInfo commitInfo) {
            this.parentBefore = null;
            this.parentAfter = parentAfter;
            this.commitInfo = commitInfo;
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            String name = after.getName();
            if (TOKEN_PROPERTY_NAMES.contains(name)) {
                this.verifyCommitInfo();
                if (!this.isTokenTree(this.parentAfter)) {
                    String msg = "Attempt to create reserved token property " + name;
                    throw TokenValidatorProvider.constraintViolation(60, msg);
                }
            }
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            String propertyName = after.getName();
            if ("rep:token.key".equals(propertyName)) {
                String msg = "Attempt to change reserved token property " + propertyName;
                throw TokenValidatorProvider.constraintViolation(61, msg);
            }
            if ("rep:token.exp".equals(propertyName)) {
                this.verifyCommitInfo();
            } else if ("jcr:primaryType".equals(propertyName)) {
                if ("rep:Token".equals(after.getValue(Type.STRING))) {
                    throw TokenValidatorProvider.constraintViolation(62, "Changing primary type of existing node to the reserved token node type.");
                }
                if (this.isTokensParent(this.parentAfter) && "rep:Unstructured".equals(before.getValue(Type.STRING))) {
                    throw TokenValidatorProvider.constraintViolation(69, "Cannot change the primary type of an existing .tokens node.");
                }
            }
        }

        @Nullable
        public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
            Tree tree = this.parentAfter.getChild(name);
            if (this.isTokenTree(tree)) {
                this.validateTokenTree(tree);
                return null;
            }
            if (this.isTokensParent(tree)) {
                this.validateTokensParent(tree);
            }
            return new VisibleValidator((Validator)new TokenValidator(tree, this.commitInfo), true, true);
        }

        public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            Tree beforeTree = TokenValidatorProvider.verifyNotNull(this.parentBefore).getChild(name);
            Tree afterTree = this.parentAfter.getChild(name);
            if (this.isTokenTree(beforeTree) || this.isTokenTree(afterTree)) {
                this.validateTokenTree(afterTree);
            } else if (this.isTokensParent(name)) {
                this.validateTokensParent(afterTree);
            }
            return new VisibleValidator((Validator)new TokenValidator(beforeTree, afterTree, this.commitInfo), true, true);
        }

        private void verifyCommitInfo() throws CommitFailedException {
            if (!CommitMarker.isValidCommitInfo(this.commitInfo)) {
                throw TokenValidatorProvider.constraintViolation(63, "Attempt to manually create or change a token node or it's parent.");
            }
        }

        private void verifyHierarchy(@NotNull String path) throws CommitFailedException {
            if (!Text.isDescendant((String)TokenValidatorProvider.this.userRootPath, (String)path)) {
                String msg = "Attempt to create a token (or it's parent) outside of configured scope " + path;
                throw TokenValidatorProvider.constraintViolation(64, msg);
            }
        }

        private boolean isTokenTree(@NotNull Tree tree) {
            return "rep:Token".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
        }

        private void validateTokenTree(@NotNull Tree tokenTree) throws CommitFailedException {
            this.verifyCommitInfo();
            this.verifyHierarchy(tokenTree.getPath());
            Tree parent = tokenTree.getParent();
            if (!this.isTokensParent(parent) || !"rep:User".equals(TreeUtil.getPrimaryTypeName((Tree)parent.getParent()))) {
                throw TokenValidatorProvider.constraintViolation(65, "Invalid location of token node.");
            }
            String key = TreeUtil.getString((Tree)tokenTree, (String)"rep:token.key");
            if (PasswordUtil.isPlainTextPassword((String)key)) {
                throw TokenValidatorProvider.constraintViolation(66, "Invalid token key.");
            }
            if (TreeUtil.getString((Tree)tokenTree, (String)"rep:token.exp") == null) {
                throw TokenValidatorProvider.constraintViolation(67, "Mandatory token expiration missing.");
            }
        }

        private boolean isTokensParent(@NotNull Tree tree) {
            return this.isTokensParent(tree.getName());
        }

        private boolean isTokensParent(@NotNull String name) {
            return ".tokens".equals(name);
        }

        private void validateTokensParent(@NotNull Tree tokensParent) throws CommitFailedException {
            this.verifyHierarchy(tokensParent.getPath());
            Tree userTree = tokensParent.getParent();
            if (!"rep:User".equals(TreeUtil.getPrimaryTypeName((Tree)userTree))) {
                throw TokenValidatorProvider.constraintViolation(68, "Invalid location of .tokens node.");
            }
            String nt = TreeUtil.getPrimaryTypeName((Tree)tokensParent);
            if (!"rep:Unstructured".equals(nt)) {
                log.debug("Unexpected node type of .tokens node {}.", (Object)nt);
            }
        }
    }
}

