/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class SimpleNodeAggregator
implements QueryIndex.NodeAggregator {
    public static final String INCLUDE_ALL = "*";
    private final List<ChildNameRule> aggregates = new ArrayList<ChildNameRule>();

    public Iterator<String> getParents(NodeState root, String path) {
        return this.getParents(root, path, true);
    }

    private Iterator<String> getParents(NodeState root, String path, boolean acceptStarIncludes) {
        int levelsUp = 0;
        HashSet<String> primaryType = new HashSet<String>();
        block0: for (ChildNameRule r : this.aggregates) {
            String name = PathUtils.getName((String)path);
            for (String inc : r.includes) {
                if (name.equals(PathUtils.getName((String)inc))) {
                    levelsUp = PathUtils.getDepth((String)inc);
                    primaryType.add(r.primaryType);
                    if (acceptStarIncludes) continue block0;
                }
                if (!acceptStarIncludes || !INCLUDE_ALL.equals(PathUtils.getName((String)inc))) continue;
                levelsUp = Math.max(PathUtils.getDepth((String)inc), levelsUp);
                primaryType.add(r.primaryType);
            }
        }
        if (levelsUp > 0 && !primaryType.isEmpty()) {
            ArrayList<String> parents = new ArrayList<String>();
            levelsUp = Math.min(levelsUp, PathUtils.getDepth((String)path));
            String parentPath = path;
            for (int i = 0; i < levelsUp; ++i) {
                if (!SimpleNodeAggregator.isNodeType(root, parentPath = PathUtils.getParentPath((String)parentPath), primaryType)) continue;
                parents.add(parentPath);
                parents.addAll(ListUtils.toList(this.getParents(root, parentPath, false)));
                return parents.iterator();
            }
        }
        return Collections.emptyIterator();
    }

    private static boolean isNodeType(NodeState root, String path, Set<String> types) {
        NodeState state = root;
        for (String p : PathUtils.elements((String)path)) {
            if (state.hasChildNode(p)) {
                state = state.getChildNode(p);
                continue;
            }
            return false;
        }
        PropertyState ps = state.getProperty("jcr:primaryType");
        if (ps == null) {
            return false;
        }
        return types.contains(ps.getValue(Type.STRING));
    }

    public SimpleNodeAggregator newRuleWithName(String primaryType, List<String> includes) {
        this.aggregates.add(new ChildNameRule(primaryType, includes));
        return this;
    }

    private static class ChildNameRule
    implements Rule {
        private final String primaryType;
        private final List<String> includes;

        ChildNameRule(String primaryType, List<String> includes) {
            this.primaryType = primaryType;
            this.includes = includes;
        }
    }

    private static interface Rule {
    }
}

