/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.configuration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.silverpeas.core.jcr.impl.oak.configuration.DocumentNodeStoreConfiguration;
import org.silverpeas.core.jcr.impl.oak.configuration.SegmentNodeStoreConfiguration;
import org.silverpeas.core.jcr.impl.oak.configuration.StorageType;

public class OakRepositoryConfiguration {
    private final StorageType storage;
    private final SegmentNodeStoreConfiguration segmentNodeStore;
    private final DocumentNodeStoreConfiguration documentNodeStore;

    public static OakRepositoryConfiguration load(String path) throws IOException {
        try (InputStream input = OakRepositoryConfiguration.openConfigFileAt(path);){
            Properties properties = new Properties();
            properties.load(input);
            OakRepositoryConfiguration oakRepositoryConfiguration = new OakRepositoryConfiguration(properties);
            return oakRepositoryConfiguration;
        }
    }

    private OakRepositoryConfiguration(@Nonnull Properties props) {
        Objects.requireNonNull(props, "The configuration of the Oak repository shouldn't be null");
        this.storage = StorageType.fromValue(props.getProperty("storage"));
        this.segmentNodeStore = new SegmentNodeStoreConfiguration(props);
        this.documentNodeStore = new DocumentNodeStoreConfiguration(props);
    }

    public StorageType getStorageType() {
        return this.storage;
    }

    public SegmentNodeStoreConfiguration getSegmentNodeStoreConfiguration() {
        return this.segmentNodeStore;
    }

    public DocumentNodeStoreConfiguration getDocumentNodeStoreConfiguration() {
        return this.documentNodeStore;
    }

    private static InputStream openConfigFileAt(String path) throws IOException {
        if (path.startsWith("classpath:")) {
            return OakRepositoryConfiguration.openInClassPath(path.substring(10));
        }
        Path configFilePath = Path.of(path, new String[0]);
        if (Files.exists(configFilePath, new LinkOption[0])) {
            return Files.newInputStream(configFilePath, new OpenOption[0]);
        }
        return OakRepositoryConfiguration.openInClassPath(path);
    }

    private static InputStream openInClassPath(String path) throws IOException {
        InputStream inputStream = OakRepositoryConfiguration.class.getResourceAsStream(path);
        if (inputStream == null) {
            throw new FileNotFoundException("The configuration file at " + path + " isn't found neither in the filesystem nor in the classpath");
        }
        return inputStream;
    }
}

