/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.silverpeas.core.jcr.SilverpeasRepositoryFactory;
import org.silverpeas.core.jcr.impl.ResourcesCloser;
import org.silverpeas.core.jcr.impl.oak.OakRepository;
import org.silverpeas.core.jcr.impl.oak.configuration.OakRepositoryConfiguration;
import org.silverpeas.core.jcr.impl.oak.configuration.StorageType;
import org.silverpeas.core.jcr.impl.oak.factories.CompositeNodeStoreFactory;
import org.silverpeas.core.jcr.impl.oak.factories.DocumentNodeStoreFactory;
import org.silverpeas.core.jcr.impl.oak.factories.MemoryNodeStoreFactory;
import org.silverpeas.core.jcr.impl.oak.factories.NodeStoreFactory;
import org.silverpeas.core.jcr.impl.oak.factories.SegmentNodeStoreFactory;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class OakRepositoryFactory
implements SilverpeasRepositoryFactory {
    private final Map<StorageType, Supplier<NodeStoreFactory>> nodeStoreFactories = Map.of(StorageType.MEMORY_NODE_STORE, MemoryNodeStoreFactory::new, StorageType.SEGMENT_NODE_STORE, SegmentNodeStoreFactory::new, StorageType.DOCUMENT_NODE_STORE, DocumentNodeStoreFactory::new, StorageType.COMPOSITE_NODE_STORE, CompositeNodeStoreFactory::new);

    public Repository getRepository(Map parameters) throws RepositoryException {
        try {
            String jcrHomePath = (String)parameters.get("jcr.home");
            String confPath = (String)parameters.get("jcr.conf");
            if (StringUtil.isNotDefined((String)jcrHomePath) || StringUtil.isNotDefined((String)confPath)) {
                return null;
            }
            OakRepositoryConfiguration conf = OakRepositoryConfiguration.load(confPath);
            NodeStoreFactory nodeStoreFactory = this.nodeStoreFactories.getOrDefault((Object)conf.getStorageType(), () -> new InvalidNodeStoreFactory()).get();
            NodeStore nodeStore = nodeStoreFactory.create(jcrHomePath, conf);
            OakRepository repository = OakRepository.create(nodeStore);
            ResourcesCloser.get().register(repository::shutdown);
            return repository;
        }
        catch (IOException | SilverpeasRuntimeException e) {
            throw new RepositoryException(e);
        }
    }

    private static class InvalidNodeStoreFactory
    implements NodeStoreFactory {
        private InvalidNodeStoreFactory() {
        }

        @Override
        public NodeStore create(String jcrHomePath, OakRepositoryConfiguration conf) {
            SilverLogger.getLogger((Object)this).error("Invalid storage type: " + String.valueOf((Object)conf.getStorageType()), new Object[0]);
            return null;
        }
    }
}

