/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.exception;

import edu.psu.swe.scim.spec.protocol.ErrorMessageType;
import edu.psu.swe.scim.spec.protocol.data.ErrorResponse;
import javax.ws.rs.core.Response;

public class ScimServerException
extends Exception {
    private static final long serialVersionUID = -3803568677019909403L;
    private final ErrorResponse errorResponse;

    public ScimServerException(Response.Status status, String detail) {
        super(ScimServerException.formatMessage(status, null, detail));
        this.errorResponse = new ErrorResponse(status, detail);
    }

    public ScimServerException(Response.Status status, String detail, Exception e) {
        super(ScimServerException.formatMessage(status, null, detail), e);
        this.errorResponse = new ErrorResponse(status, detail);
    }

    public ScimServerException(Response.Status status, ErrorMessageType errorMessageType, String detail) {
        super(ScimServerException.formatMessage(status, errorMessageType, detail));
        this.errorResponse = new ErrorResponse(status, detail);
        this.errorResponse.setScimType(errorMessageType);
    }

    public ScimServerException(Response.Status status, ErrorMessageType errorMessageType, String detail, Exception e) {
        super(ScimServerException.formatMessage(status, errorMessageType, detail), e);
        this.errorResponse = new ErrorResponse(status, detail);
        this.errorResponse.setScimType(errorMessageType);
    }

    private static String formatMessage(Response.Status status, ErrorMessageType errorMessageType, String detail) {
        return "Scim Error: " + status + (errorMessageType != null ? " (" + errorMessageType + ")" : "") + ", " + detail;
    }

    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }
}

