/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.report;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.meta;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.title;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.importexport.report.ExportReport;
import org.silverpeas.core.importexport.report.HtmlExportPublicationGenerator;
import org.silverpeas.core.node.importexport.NodeTreeType;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

public class HtmlExportGenerator {
    private static final String NEW_LINE = "<br>\n";
    private String fileExportDir;
    private ExportReport exportReport;
    private LocalizationBundle messages;

    public HtmlExportGenerator(ExportReport exportReport, String fileExportDir) {
        this.fileExportDir = fileExportDir;
        this.exportReport = exportReport;
        this.messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.importExport.multilang.importExportBundle");
    }

    public HtmlExportGenerator(ExportReport exportReport, String fileExportDir, LocalizationBundle messages) {
        this.fileExportDir = fileExportDir;
        this.exportReport = exportReport;
        this.messages = messages;
    }

    public static String encode(String javastring) {
        StringBuilder sb = new StringBuilder("");
        if (javastring != null) {
            String res = WebEncodeHelper.javaStringToHtmlString((String)javastring);
            block4: for (int i2 = 0; i2 < res.length(); ++i2) {
                switch (res.charAt(i2)) {
                    case '\n': {
                        sb.append("<br>");
                        continue block4;
                    }
                    case '\t': {
                        sb.append("&nbsp;&nbsp;");
                        continue block4;
                    }
                    default: {
                        sb.append(res.charAt(i2));
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String getHtmlStyle() {
        ElementContainer xhtmlcontainer = new ElementContainer();
        xhtmlcontainer.addElement((Element)new link().setType("text/css").setRel("stylesheet").setHref("treeview/display.css"));
        return xhtmlcontainer.toString();
    }

    String writeEnTeteSommaire(String text) {
        ElementContainer xhtmlcontainer = new ElementContainer();
        div entete = new div();
        entete.setClass("numberOfDocument");
        entete.addElement(HtmlExportGenerator.encode(text));
        xhtmlcontainer.addElement((Element)entete);
        return xhtmlcontainer.toString();
    }

    String getBeginningOfPage(String title2, boolean treeview) {
        ElementContainer xhtmlcontainer = new ElementContainer();
        head header = new head();
        header.addElement((Element)new title(title2));
        header.addElement((Element)new meta().setContent("text/html; charset=UTF-8").setHttpEquiv("Content-Type"));
        header.addElement(HtmlExportGenerator.getHtmlStyle());
        if (treeview) {
            header.addElement((Element)new script().setType("text/javascript").setSrc("treeview/TreeView.js"));
            header.addElement((Element)new script().setType("text/javascript").setSrc("treeview/TreeViewElements.js"));
            header.addElement((Element)new link().setType("text/css").setRel("stylesheet").setHref("treeview/treeview.css"));
        }
        xhtmlcontainer.addElement("<html>");
        xhtmlcontainer.addElement((Element)header);
        return xhtmlcontainer.toString();
    }

    public String toHTML() {
        StringBuilder sb = new StringBuilder();
        String htmlFileExportDir = HtmlExportGenerator.encode(this.fileExportDir);
        sb.append(this.getBeginningOfPage("Sommaire de " + htmlFileExportDir, false));
        sb.append("<body>\n");
        Map<String, HtmlExportPublicationGenerator> map = this.exportReport.getMapIndexHtmlPaths();
        if (map != null) {
            StringBuilder entete = new StringBuilder(100);
            entete.append(map.size()).append(" Documents dans ").append(htmlFileExportDir);
            sb.append(this.writeEnTeteSommaire(entete.toString()));
            sb.append(NEW_LINE);
            for (Map.Entry<String, HtmlExportPublicationGenerator> entry : map.entrySet()) {
                HtmlExportPublicationGenerator s = entry.getValue();
                sb.append(s.toHtmlSommairePublication());
            }
        }
        sb.append(this.getEndOfPage());
        return sb.toString();
    }

    public String toHTML(String fileName, Collection<String> pubIds) {
        StringBuilder sb = new StringBuilder();
        String htmlFileExportDir = HtmlExportGenerator.encode(fileName);
        sb.append(this.getBeginningOfPage(htmlFileExportDir, false));
        sb.append("<body>\n");
        Map<String, HtmlExportPublicationGenerator> map = this.exportReport.getMapIndexHtmlPaths();
        if (map != null) {
            StringBuilder header = new StringBuilder();
            header.append(pubIds.size()).append(" ");
            if (pubIds.size() == 1) {
                header.append(this.messages.getString("importExport.document"));
            } else {
                header.append(this.messages.getString("importExport.documents"));
            }
            sb.append(this.writeEnTeteSommaire(header.toString()));
            sb.append(NEW_LINE);
            for (Map.Entry<String, HtmlExportPublicationGenerator> entry : map.entrySet()) {
                String pubId = entry.getKey();
                if (!pubIds.contains(pubId)) continue;
                HtmlExportPublicationGenerator generator = entry.getValue();
                sb.append(generator.toHtmlSommairePublication());
            }
        }
        sb.append(this.getEndOfPage());
        return sb.toString();
    }

    public String toHTML(String fileName) {
        StringBuilder sb = new StringBuilder();
        String htmlFileExportDir = HtmlExportGenerator.encode(fileName);
        sb.append(this.getBeginningOfPage(htmlFileExportDir, false));
        sb.append("<body>\n");
        sb.append(this.writeEnTeteSommaire("0 " + this.messages.getString("importExport.document")));
        sb.append(NEW_LINE);
        sb.append(this.messages.getString("importExport.empty"));
        sb.append(this.getEndOfPage());
        return sb.toString();
    }

    public String indexToHTML(String fileName, Set<String> topicIds, List<NodeTreeType> nodeTrees, String rootId) {
        StringBuilder sb = new StringBuilder();
        String htmlFileExportDir = HtmlExportGenerator.encode(fileName);
        sb.append(this.getBeginningOfPage(this.messages.getString("importExport.index") + " " + htmlFileExportDir, true));
        sb.append("<body>\n");
        sb.append("<div id=\"treeview\">\n");
        sb.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        sb.append("var elements_treeview = new TreeViewElements();\n");
        sb.append(this.nodeTreeToHTML(nodeTrees, topicIds, rootId));
        sb.append("var treeview = new TreeView(\"treeview\");\n");
        sb.append("treeview.define (elements_treeview);\n");
        sb.append("treeview.validate();\n");
        sb.append("treeview.height = \"590px\";\n");
        sb.append("treeview.width = \"300px\";\n");
        sb.append("treeview.load_all = false;\n");
        sb.append("treeview.use_preloader_feature = false;\n");
        sb.append("treeview.preloader_position = \"top\";\n");
        sb.append("treeview.preloader_addButton = true;\n");
        sb.append("treeview.use_folder_feature = true;\n");
        sb.append("treeview.use_link_feature = true;\n");
        sb.append("treeview.link_target = \"publis\";\n");
        sb.append("treeview.link_prefix = \"indexTopic\";\n");
        sb.append("treeview.link_suffix = \".html\";\n");
        sb.append("treeview.link_add_nodeId = false;\n");
        sb.append("treeview.display();\n");
        sb.append("treeview.control.ondblclick = function ( ) { window.status = \"control\" ; }\n");
        sb.append("goto_link(\"treeview\", 0, treeview.link_target, treeview.link_prefix + elements_treeview.attribute(0, \"Lien\") + treeview.link_suffix);\n");
        sb.append("</script>\n");
        sb.append("</div>");
        sb.append("<div id=\"frameContent\">");
        sb.append("<iframe name=\"publis\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"auto\"/>");
        sb.append("</div>\n");
        sb.append(this.getEndOfPage());
        return sb.toString();
    }

    private String nodeTreeToHTML(List<NodeTreeType> nodeTrees, Set<String> topicIds, String rootId) {
        StringBuilder sb = new StringBuilder();
        for (NodeTreeType nodeTree : nodeTrees) {
            Collection childrens;
            NodeDetail node = nodeTree.getNodeDetail();
            String fatherId = node.getFatherPK().getId();
            String nodeId = node.getNodePK().getId();
            if ("-1".equals(fatherId)) {
                fatherId = "0";
            }
            if ("0".equals(rootId)) {
                String componentName = OrganizationControllerProvider.getOrganisationController().getComponentInstLight(node.getNodePK().getInstanceId()).getLabel();
                if (topicIds.contains(nodeId)) {
                    sb.append(this.filledTreeElement(componentName, nodeId, fatherId));
                } else {
                    sb.append(this.emptyTreeElement(node.getName(), nodeId, fatherId));
                }
            }
            if ((childrens = node.getChildrenDetails()) == null) continue;
            sb.append(this.topicToHTML(childrens, topicIds, rootId, false));
        }
        return sb.toString();
    }

    private String topicToHTML(Collection<NodeDetail> nodes, Set<String> topicIds, String rootId, boolean found) {
        StringBuilder sb = new StringBuilder();
        for (NodeDetail node : nodes) {
            Collection childrens;
            String fatherId = node.getFatherPK().getId();
            String nodeId = node.getNodePK().getId();
            if ("-1".equals(fatherId)) {
                fatherId = "0";
            }
            if (!"0".equals(rootId) && !found) {
                childrens = node.getChildrenDetails();
                if (nodeId.equals(rootId)) {
                    if (topicIds.contains(nodeId)) {
                        sb.append("elements_treeview.addElement(\"").append(node.getName());
                        sb.append("\", 0, 0, \"dossier\", \"folder\", ");
                        sb.append(nodeId).append(");\n");
                    } else {
                        sb.append(this.emptyTreeElement(node.getName(), "0", "0"));
                    }
                    if (childrens == null) continue;
                    sb.append(this.topicToHTML(childrens, topicIds, rootId, true));
                    continue;
                }
                if (childrens == null) continue;
                sb.append(this.topicToHTML(childrens, topicIds, rootId, false));
                continue;
            }
            if (found) {
                if (topicIds.contains(nodeId)) {
                    sb.append(this.filledTreeElement(node.getName(), nodeId, "0"));
                } else {
                    sb.append(this.emptyTreeElement(node.getName(), nodeId, "0"));
                }
            } else if (!node.getNodePK().isTrash() && !node.getNodePK().isUnclassed()) {
                if (topicIds.contains(nodeId)) {
                    sb.append(this.filledTreeElement(node.getName(), nodeId, fatherId));
                } else {
                    sb.append(this.emptyTreeElement(node.getName(), nodeId, fatherId));
                }
            }
            if ((childrens = node.getChildrenDetails()) == null) continue;
            sb.append(this.topicToHTML(childrens, topicIds, "0", false));
        }
        return sb.toString();
    }

    String emptyTreeElement(String name, String nodeId, String fatherId) {
        return "elements_treeview.addElement(\"" + name + "\", " + nodeId + ", " + fatherId + ", \"dossier\", \"folder\", \"Empty\");\n";
    }

    String filledTreeElement(String name, String nodeId, String fatherId) {
        return "elements_treeview.addElement(\"" + name + "\", " + nodeId + ", " + fatherId + ", \"dossier\", \"folder\", " + nodeId + ");\n";
    }

    private String combinationToHTML(List<String> combinationLabels) {
        StringBuilder sb = new StringBuilder();
        for (String combinationLabel : combinationLabels) {
            sb.append(combinationLabel).append("\n");
        }
        return sb.toString();
    }

    public String kmaxAxisToHTML(List<NodeDetail> axis, String language) {
        StringBuilder sb = new StringBuilder();
        String htmlFileExportDir = HtmlExportGenerator.encode(this.fileExportDir);
        sb.append(this.getBeginningOfPage(this.messages.getString("importExport.index") + htmlFileExportDir, false));
        sb.append("<body>\n");
        sb.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        sb.append("function submit(nbAxis) { \n");
        sb.append("var selection=\"\"; \n");
        sb.append("var positionPath=\"\"; \n");
        sb.append("var num=0;\n");
        sb.append("var fileHtml=\"index-\";\n");
        sb.append("for (i=1; i<=nbAxis; i++) {\n");
        sb.append("position = document.getElementById(i).options[");
        sb.append("document.getElementById(i).options.selectedIndex].value; \n");
        sb.append("positionPath += position; \n");
        sb.append("if (i<nbAxis) \n");
        sb.append("positionPath += \"-\";\n");
        sb.append("}\n");
        sb.append("fileHtml += positionPath + \".html\";\n");
        sb.append("publications").append(".location.href = \"empty.html\";\n");
        sb.append("indexPublications").append(".location.href = fileHtml;\n");
        sb.append("}\n");
        sb.append("</script>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append(NEW_LINE);
        sb.append("<table width=\"100%\" align=\"center\" cellspacing=\"0\" cellpadding=\"2\" bgcolor=\"#B3BFD1\">\n");
        sb.append("<tr>\n");
        sb.append("<td width=\"100%\" align=\"center\">\n");
        sb.append("<b>").append(this.messages.getString("importExport.criteria")).append("<b>\n");
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("</table>\n");
        int axisNb = 0;
        sb.append("<table border=0 width=\"100%\" valign=center cellspacing=\"0\" cellpadding=\"2\" class=\"intfdcolor\">\n");
        sb.append("<tr>\n");
        for (NodeDetail node : axis) {
            if (node.getLevel() == 2) {
                String axisName = node.getName();
                if (++axisNb > 1) {
                    sb.append("</select>\n");
                    sb.append("</td>\n");
                }
                sb.append("<td align=\"center\"><b>").append(axisName).append("</b><br>\n");
                sb.append("<select id=\"").append(axisNb).append("\" name=\"sel").append(axisNb);
                sb.append("\" size=\"1\">");
                sb.append("<option value=\"").append(node.getNodePK().getId()).append("\">");
                sb.append(this.messages.getString("importExport.allCategories")).append("</option>");
                continue;
            }
            if (node.getLevel() == 3) {
                sb.append("<option value=\"").append(node.getNodePK().getId());
                sb.append("\" class=\"intfdcolor51\">");
                sb.append(WebEncodeHelper.javaStringToHtmlString((String)node.getName(language))).append("</option>\n");
                continue;
            }
            StringBuilder spaces = new StringBuilder();
            for (int i2 = 0; i2 < node.getLevel() - 3; ++i2) {
                spaces.append("&nbsp;&nbsp;");
                sb.append("<option value=\"").append(node.getNodePK().getId());
                sb.append("\" class=\"intfdcolor5\">").append(spaces.toString());
                sb.append(WebEncodeHelper.javaStringToHtmlString((String)node.getName(language)));
                sb.append("</option>\n");
            }
        }
        sb.append("</tr>\n");
        sb.append("<tr><td>&nbsp;</td></tr>\n");
        sb.append("<tr><td><a target=\"indexPublications\" href=\"index-2.html\">");
        sb.append(this.messages.getString("importExport.unbalanced")).append("</a></td></tr>\n");
        sb.append("<t><td colspan=\"").append(axisNb);
        sb.append("\" align=\"center\"><input type=\"button\" value=\"");
        sb.append(this.messages.getString("importExport.validate"));
        sb.append("\" onClick=\"javascript:submit(").append(axisNb).append(")\"></td></tr>\n");
        sb.append("</table>\n");
        sb.append("<div align=\"center\">\n");
        sb.append("</div>\n");
        sb.append("<table border=0 height=\"100%\" width=\"100%\">\n");
        sb.append("<tr>\n");
        sb.append("<td height=\"100%\" width=\"40%\">\n");
        sb.append("<iframe name=\"indexPublications\" width=\"100%\" height=\"100%\" ");
        sb.append("frameborder=\"0\" scrolling=\"auto\"></iframe>\n");
        sb.append("</td>\n");
        sb.append("<td height=\"100%\" width=\"60%\">\n");
        sb.append("<iframe name=\"publications\" width=\"100%\" height=\"100%\" ");
        sb.append("frameborder=\"0\" scrolling=\"auto\"></iframe>\n");
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("</table>\n");
        sb.append(this.getEndOfPage());
        return sb.toString();
    }

    public String kmaxPublicationsToHTML(List<String> combinationLabels, String timeCriteria, String iframe) {
        StringBuilder sb = new StringBuilder();
        String htmlFileExportDir = HtmlExportGenerator.encode(this.fileExportDir);
        sb.append("<html>\n<head>\n<title>").append(this.messages.getString("importExport.index"));
        sb.append(htmlFileExportDir).append("</title>");
        sb.append(HtmlExportGenerator.getHtmlStyle());
        sb.append("</head>\n<body>\n");
        if (!combinationLabels.isEmpty()) {
            sb.append("<table width=\"100%\" align=center cellspacing=\"0\" cellpadding=\"2\" bgcolor=\"#B3BFD1\">\n");
            sb.append("<tr>\n");
            sb.append("<td width=\"100%\" align=\"center\">\n");
            sb.append("<b>").append(this.messages.getString("importExport.criteria")).append("</b>\n");
            sb.append("</td>\n");
            sb.append("</tr>\n");
            sb.append("</table>\n");
            sb.append(NEW_LINE);
            sb.append(this.combinationToHTML(combinationLabels));
            sb.append(NEW_LINE);
            if (StringUtil.isDefined((String)timeCriteria)) {
                sb.append(timeCriteria);
            }
        }
        sb.append("<table border=0 height=\"100%\" width=\"100%\">\n");
        sb.append("<tr>\n");
        sb.append("<td height=\"100%\" valign=\"top\" width=\"40%\">\n");
        Map<String, HtmlExportPublicationGenerator> map = this.exportReport.getMapIndexHtmlPaths();
        if (map != null) {
            StringBuilder entete = new StringBuilder(100);
            entete.append(map.size()).append(" ");
            entete.append(this.messages.getString("importExport.documentsIn")).append(" ");
            entete.append(htmlFileExportDir);
            sb.append(this.writeEnTeteSommaire(entete.toString()));
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
            for (Map.Entry<String, HtmlExportPublicationGenerator> entry : map.entrySet()) {
                HtmlExportPublicationGenerator s = entry.getValue();
                sb.append(s.toHtmlSommairePublication(iframe));
            }
        }
        sb.append("</td>\n");
        sb.append("<td height=\"100%\" width=\"60%\">\n");
        sb.append("<iframe name=\"publications\" width=\"100%\" height=\"100%\" ");
        sb.append("frameborder=\"0\" scrolling=\"auto\"></iframe>\n");
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("</table>\n");
        sb.append(this.getEndOfPage());
        return sb.toString();
    }

    public String toHtmlPublicationsByPositionStart() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n").append("<head>\n");
        sb.append(HtmlExportGenerator.getHtmlStyle());
        sb.append("<title>").append("</title>");
        sb.append("</head>\n").append("<body>\n");
        return sb.toString();
    }

    public String toHtmlPublicationsNumber(String positionPathName) {
        StringBuilder sb = new StringBuilder();
        Map<String, HtmlExportPublicationGenerator> map = this.exportReport.getMapIndexHtmlPaths();
        if (map != null && !map.isEmpty()) {
            StringBuilder entete = new StringBuilder(100);
            entete.append(map.size()).append(" ");
            entete.append(this.messages.getString("importExport.documentsIn")).append(" ");
            entete.append(positionPathName);
            sb.append(this.writeEnTeteSommaire(entete.toString()));
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public String getEndOfPage() {
        return "</body>\n</html>\n";
    }
}

