/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.attachment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.importexport.attachment.AttachmentDetail;
import org.silverpeas.core.importexport.form.FormTemplateImportExport;
import org.silverpeas.core.importexport.form.XMLModelContentType;
import org.silverpeas.core.util.error.SilverpeasTransverseErrorUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

public class AttachmentImportExport {
    private final UserDetail user;
    private final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.importExport.settings.importSettings");

    public AttachmentImportExport(UserDetail user) {
        this.user = user;
    }

    public List<Pair<AttachmentDetail, SimpleDocument>> importAttachments(String pubId, String componentId, List<AttachmentDetail> attachments, boolean indexIt) {
        ArrayList<Pair<AttachmentDetail, SimpleDocument>> createdDocuments = new ArrayList<Pair<AttachmentDetail, SimpleDocument>>(attachments.size());
        FormTemplateImportExport xmlIE = null;
        for (AttachmentDetail attDetail : attachments) {
            boolean removed;
            attDetail.setAuthor(this.user.getId());
            attDetail.setInstanceId(componentId);
            XMLModelContentType xmlContent = attDetail.getXMLModelContentType();
            if (xmlContent != null) {
                attDetail.setXmlForm(xmlContent.getName());
            }
            try (InputStream input = this.getAttachmentContent(attDetail);){
                createdDocuments.add((Pair<AttachmentDetail, SimpleDocument>)Pair.of((Object)attDetail, (Object)this.addAttachmentToPublication(pubId, componentId, attDetail, input, indexIt)));
                if (xmlContent != null) {
                    if (xmlIE == null) {
                        xmlIE = new FormTemplateImportExport();
                    }
                    ResourceReference pk = new ResourceReference(attDetail.getPK().getId(), attDetail.getPK().getInstanceId());
                    xmlIE.importXMLModelContentType(pk, "Attachment", xmlContent, attDetail.getAuthor());
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
                SilverpeasTransverseErrorUtil.throwTransverseErrorIfAny((Exception)e, null);
            }
            if (!attDetail.isRemoveAfterImport() || (removed = FileUtils.deleteQuietly((File)this.getAttachmentFile(attDetail)))) continue;
            SilverLogger.getLogger((Object)this).error("Can''t remove file {0}", new Object[]{this.getAttachmentFile(attDetail).toString()});
        }
        return createdDocuments;
    }

    private SimpleDocument addAttachmentToPublication(String pubId, String componentId, AttachmentDetail attachment, InputStream input, boolean indexIt) {
        SimpleDocumentPK attachmentPk = new SimpleDocumentPK(null, componentId);
        ResourceReference foreignKey = new ResourceReference(pubId, componentId);
        SimpleDocumentList existingAttachments = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.attachment, null);
        String logicalName = attachment.getLogicalName();
        if (!StringUtil.isDefined((String)logicalName)) {
            logicalName = FileUtil.getFilename((String)attachment.getPhysicalName());
        }
        String userId = attachment.getAuthor();
        String updateRule = attachment.getImportUpdateRule();
        if (!StringUtil.isDefined((String)updateRule) || "null".equalsIgnoreCase(updateRule)) {
            updateRule = "add";
        }
        logicalName = this.computeUniqueName(attachment, 0, (List<SimpleDocument>)existingAttachments, logicalName, updateRule);
        attachment.setLogicalName(logicalName);
        Date creationDate = attachment.getCreationDate();
        if (creationDate == null) {
            creationDate = new Date();
        }
        SimpleAttachment copy = SimpleAttachment.builder().setFilename(attachment.getLogicalName()).setTitle(attachment.getTitle()).setDescription(attachment.getDescription()).setSize(attachment.getSize()).setContentType(FileUtil.getMimeType((String)attachment.getPhysicalName())).setCreationData(userId, creationDate).setFormId(attachment.getXmlForm()).build();
        SimpleDocument documentToCreate = new SimpleDocument(attachmentPk, pubId, -1, false, copy);
        return AttachmentServiceProvider.getAttachmentService().createAttachment(documentToCreate, input, indexIt);
    }

    private String computeUniqueName(AttachmentDetail attachment, int increment, List<SimpleDocument> existingAttachments, String logicalName, String updateRule) {
        String normalizedUniqueName = StringUtil.normalize((String)logicalName);
        int incrementSuffix = increment + 1;
        for (SimpleDocument existingDocument : existingAttachments) {
            if (!existingDocument.getFilename().equals(normalizedUniqueName)) continue;
            if (existingDocument.getSize() != attachment.getSize() && "add".equalsIgnoreCase(updateRule)) {
                String baseName = FilenameUtils.getBaseName((String)attachment.getLogicalName());
                String extension = FilenameUtils.getExtension((String)attachment.getLogicalName());
                String incrementedLogicalName = baseName + "_" + incrementSuffix + (String)(StringUtil.isDefined((String)extension) ? "." + extension : "");
                return this.computeUniqueName(attachment, incrementSuffix, existingAttachments, incrementedLogicalName, updateRule);
            }
            AttachmentServiceProvider.getAttachmentService().deleteAttachment(existingDocument);
            return normalizedUniqueName;
        }
        return normalizedUniqueName;
    }

    public List<AttachmentDetail> getAttachments(ResourceReference pk, String exportPath, String relativeExportPath, String extensionFilter) {
        SimpleDocumentList listAttachment = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKey(pk, null);
        ArrayList<AttachmentDetail> listToReturn = new ArrayList<AttachmentDetail>(listAttachment.size());
        if (!listAttachment.isEmpty()) {
            for (SimpleDocument attachment : listAttachment) {
                if (attachment.getDocumentType() != DocumentType.attachment || !attachment.isDownloadAllowedForRolesFrom((User)this.user) || extensionFilter != null && !FileRepositoryManager.getFileExtension((String)attachment.getFilename()).equalsIgnoreCase(extensionFilter)) continue;
                try {
                    this.copyAttachment(attachment, exportPath);
                    String physicalName = relativeExportPath + File.separator + FileServerUtils.replaceAccentChars((String)attachment.getFilename());
                    AttachmentDetail attachDetail = new AttachmentDetail(attachment, physicalName);
                    listToReturn.add(attachDetail);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error(new SilverpeasExceptionMessages.LightExceptionMessage((Object)this, e).singleLineWith(MessageFormat.format("Cannot export document #{0} ({1}) of publication #{2} ({3})", attachment.getId(), attachment.getNodeName(), attachment.getForeignId(), e.getMessage())), new Object[0]);
                }
            }
        }
        return listToReturn;
    }

    private void copyAttachment(SimpleDocument attDetail, String exportPath) {
        String fichierJointExport = exportPath + File.separatorChar + FileServerUtils.replaceAccentChars((String)attDetail.getFilename());
        AttachmentServiceProvider.getAttachmentService().getBinaryContent(new File(fichierJointExport), attDetail.getPk(), null);
    }

    public InputStream getAttachmentContent(AttachmentDetail attachment) throws FileNotFoundException {
        return new FileInputStream(this.getAttachmentFile(attachment));
    }

    public File getAttachmentFile(AttachmentDetail attachment) {
        File file = new File(FileUtil.convertPathToServerOS((String)attachment.getAttachmentPath()));
        if (!file.exists() || !file.isFile()) {
            String baseDir = this.settings.getString("importRepository", "");
            file = new File(FileUtil.convertPathToServerOS((String)(baseDir + File.separatorChar + attachment.getPhysicalName())));
        }
        attachment.setSize(file.length());
        attachment.setType(FileUtil.getMimeType((String)file.getName()));
        if (!StringUtil.isDefined((String)attachment.getLogicalName())) {
            attachment.setLogicalName(file.getName());
        }
        return file;
    }
}

